<?php

define('THIS_PLUGIN_DIR', dirname(__FILE__));
load_plugin_textdomain('egopay', 'wp-content/plugins/wp-e-commerce/wpsc-merchants/library/egopay/languages', 'wp-e-commerce/wpsc-merchants/library/egopay/languages');


$nzshpcrt_gateways[$num]['name'] = __('Egopay', 'egopay');
$nzshpcrt_gateways[$num]['internalname'] = 'egopay';
$nzshpcrt_gateways[$num]['function'] = 'gateway_egopay';
$nzshpcrt_gateways[$num]['form'] = 'form_egopay';
$nzshpcrt_gateways[$num]['submit_function'] = 'submit_egopay';
$nzshpcrt_gateways[$num]['display_name'] = __('Paying by credit card', 'egopay');


function egopay_fetch($template, $vars = array()) {
    ob_start();
    try {
        extract($vars);
        include(THIS_PLUGIN_DIR . '/library/egopay/templates/' . $template . '.php');
        $output = ob_get_contents();
    } catch (Exception $e) {
        $output = false;
    }
    ob_end_clean();
    return $output;
}


function gateway_egopay($separator, $sessionid) {
    global $wpdb, $wpsc_cart;

    $purchaseLog = $wpdb->get_results('SELECT * FROM `' . WPSC_TABLE_PURCHASE_LOGS . '` WHERE `sessionid` = ' . $sessionid . ' LIMIT 1', ARRAY_A);
    $userInfo = $wpdb->get_results('SELECT `' . WPSC_TABLE_SUBMITED_FORM_DATA . '`.value, `' . WPSC_TABLE_CHECKOUT_FORMS . '`.`name`, `' . WPSC_TABLE_CHECKOUT_FORMS . '`.`unique_name` FROM `' . WPSC_TABLE_CHECKOUT_FORMS . '` LEFT JOIN `' . WPSC_TABLE_SUBMITED_FORM_DATA . '` ON `' . WPSC_TABLE_CHECKOUT_FORMS . '`.id = `' . WPSC_TABLE_SUBMITED_FORM_DATA . '`.`form_id` WHERE `' . WPSC_TABLE_SUBMITED_FORM_DATA . '`.`log_id` = ' . $purchaseLog[0]['id'], ARRAY_A);

    $orderId = $purchaseLog[0]['id'];
    $orderAmount = number_format($wpsc_cart->total_price, 2, '.', '');
    $firstName = '';
    $lastName = '';
    $userEmail = '';
    $userPhone = '';
    foreach ((array) $userInfo as $key => $value){
        if (($value['unique_name'] == 'billingfirstname') && ($value['value'] != '')) {
            $firstName = $value['value'];
        }
        if (($value['unique_name'] == 'billinglastname') && ($value['value'] != '')) {
            $lastName = $value['value'];
        }
        if (($value['unique_name'] == 'billingemail') && ($value['value'] != '')) {
            $userEmail = $value['value'];
        }
        if (($value['unique_name'] == 'billingphone') && ($value['value'] != '')) {
            $userPhone = $value['value'];
        }
    }

    $soapClient = egopayNewSoap();
    $request = egopayPrepareOrder(
        $orderId,
        $orderAmount,
        $lastName . ' ' . $firstName,
        $userEmail,
        $userPhone,
        add_query_arg('code', $sessionid, add_query_arg('order_id', $orderId, add_query_arg('egopay_callback', 'true', home_url( '/' )))),
        add_query_arg('code', $sessionid, add_query_arg('order_id', $orderId, add_query_arg('egopay_callback', 'true', home_url( '/' ))))
    );
    try {
        $info = $soapClient->register_online($request);
        header('Location: ' . $info->redirect_url . '?session=' . $info->session);
        // echo egopay_fetch('redirect', array('url' => $info->redirect_url . '?session=' . $info->session));
    } catch (SoapFault $fault) {
        echo egopay_fetch('error', array(
            'text' => __('Error has occured. Please, contact support service and provide error code below.', 'egopay'),
            'code' => $fault->faultstring
        ));
    } catch (Exception $e) {
        echo egopay_fetch('error', array(
            'text' => __('Error has occured. Please, contact support service and provide error code below.', 'egopay'),
            'code' => $e->__toString()
        ));
    }
    die();
}


function nzshpcrt_egopay_callback() {
    if (isset($_GET['egopay_callback']) && ($_GET['egopay_callback'] == 'true')) {
        global $wpdb;

        $orderId = (int) $_GET['order_id'];
        $sessionId = (int) $_GET['code'];
        $purchaseLog = $wpdb->get_results('SELECT * FROM `' . WPSC_TABLE_PURCHASE_LOGS . '` WHERE `sessionid` = ' . $sessionId . ' AND `id` = ' . $orderId . ' LIMIT 1', ARRAY_A);
        if ($purchaseLog) {
            $soapClient = egopayNewSoap();
            $objStatus = egopayGetOrderStatus($orderId);
            try {
                $info = $soapClient->get_status($objStatus);
                switch ($info->status) {
                    case 'acknowledged':
                    case 'not_acknowledged':
                    case 'authorized':
                        $wpdb->update(WPSC_TABLE_PURCHASE_LOGS, array('processed' => 3, 'date' => time()), array('id' => $orderId), array('%d', '%s'), array('%d'));
                    break;

                    case 'canceled':
                    case 'not_authorized':
                        $wpdb->update(WPSC_TABLE_PURCHASE_LOGS, array('processed' => 6, 'date' => time()), array('id' => $orderId), array('%d', '%s'), array('%d'));
                    break;
                }
            } catch (SoapFault $fault) {
                if ($fault->faultstring === 'INVALID_ORDER') {
                    $wpdb->update(WPSC_TABLE_PURCHASE_LOGS, array('processed' => 6, 'date' => time()), array('id' => $orderId), array('%d', '%s'), array('%d'));
                } else {
                    $notice = egopay_fetch('error', array(
                        'text' => __('Error has occured. Please, contact support service and provide error code below.', 'egopay'),
                        'code' => $fault->faultstring
                    ));
                    die($notice);
                }
            } catch (Exception $e) {
                $notice = egopay_fetch('error', array(
                    'text' => __('Error has occured. Please, contact support service and provide error code below.', 'egopay'),
                    'code' => $e->__toString()
                ));
                die($notice);
            }
            wpsc_merchant::go_to_transaction_results($sessionId);
        } else {
            $notice = egopay_fetch('error', array(
                'text' => __('Wrong transaction number or verification code.', 'egopay')
            ));
            die($notice);
        }
    }

}


function submit_egopay() {
    if (isset($_POST['egopay_shop_id'])) {
        update_option('egopay_shop_id', $_POST['egopay_shop_id']);
    }

    if (isset($_POST['egopay_login'])) {
        update_option('egopay_login', $_POST['egopay_login']);
    }

    if (isset($_POST['egopay_password'])) {
        update_option('egopay_password', $_POST['egopay_password']);
    }

    if (isset($_POST['egopay_url'])) {
        update_option('egopay_url', $_POST['egopay_url']);
    }

    return true;
}


function form_egopay() {
    return egopay_fetch('form', array(
            'shop_id' => get_option('egopay_shop_id'),
            'login' => get_option('egopay_login'),
            'password' => get_option('egopay_password'),
            'url' => get_option('egopay_url')
        ));
}


function egopayUpdateStatuses() {
    global $wpdb;

    if ($orders = $wpdb->get_results('SELECT id FROM ' . WPSC_TABLE_PURCHASE_LOGS . ' WHERE `gateway` = "egopay" AND `processed` = 1')) {
        $soapClient = egopayNewSoap();
        foreach ($orders as $o) {
            $objStatus = egopayGetOrderStatus($o->id);
            try {
                $info = $soapClient->get_status($objStatus);
                switch ($info->status) {
                    case 'acknowledged':
                    case 'not_acknowledged':
                    case 'authorized':
                        $wpdb->update(WPSC_TABLE_PURCHASE_LOGS, array('processed' => 3, 'date' => time()), array('id' => $o->id), array('%d', '%s'), array('%d'));
                    break;

                    case 'canceled':
                    case 'not_authorized':
                        $wpdb->update(WPSC_TABLE_PURCHASE_LOGS, array('processed' => 6, 'date' => time()), array('id' => $o->id), array('%d', '%s'), array('%d'));
                    break;
                }
                echo 'Статус заказа № ', $o->id, ': ', $info->status, "\r\n";

            } catch (SoapFault $fault) {
                echo 'Ошибка при проверке статуса заказа № ', $o->id, ': ', $fault->faultcode , '-' , $fault->faultstring, "\r\n";
                if ($fault->faultstring === 'INVALID_ORDER') {
                    // заказ с таким номером не зарегистрирован
                    $wpdb->update(WPSC_TABLE_PURCHASE_LOGS, array('processed' => 6, 'date' => time()), array('id' => $o->id), array('%d', '%s'), array('%d'));
                }
            } catch (Exception $e) {
                echo 'Ошибка при проверке статуса заказа № ', $o->id, ': PHP Error', "\r\n";
            }
        }
    }
    
}


function egopayNewSoap() {
    require_once(THIS_PLUGIN_DIR . '/library/egopay/orderv2.php');

    return new orderv2(null, array(
        'location' => get_option('egopay_url'),
        'uri'      => 'http://www.sirena-travel.ru',
        'login'    => get_option('egopay_login'),
        'password' => get_option('egopay_password'),
        'trace'    => 0,
        'features' => SOAP_SINGLE_ELEMENT_ARRAYS,
        'connection_timeout' => 12));
}


function egopayPrepareOrder($orderId, $orderSum, $userName, $userEmail, $userPhone, $okUrl, $faultUrl) {
    $request = new register_online();
    $order = new OrderID(); 
    $order->shop_id = (int) get_option('egopay_shop_id');
    $order->number = $orderId;
    $cost = new Amount();
    $cost->amount = $orderSum;
    $cost->currency = 'RUB';
    $customer = new CustomerInfo();
    $customer->name = $userName;
    $customer->email = $userEmail;
    $customer->phone = $userPhone;
    $description = new OrderInfo();
    $description->paytype = 'card';
    $language = new PostEntry();
    $language->name = 'Language';
    $language->value = 'ru';
    $returnUrlOk = new PostEntry();
    $returnUrlOk->name = 'ReturnURLOk';
    $returnUrlOk->value = $okUrl;
    $returnUrlFault = new PostEntry();
    $returnUrlFault->name = 'ReturnURLFault';
    $returnUrlFault->value = $faultUrl;
    $cardtype = new PostEntry();
    $cardtype->name = 'ChoosenCardType';
    $cardtype->value = 'VI';
    $request->order = $order;
    $request->cost = $cost;
    $request->customer = $customer;
    $request->description = $description;

    $postdata = new SoapVar(array(
                                    new SoapVar($language, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                    new SoapVar($cardtype, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                    new SoapVar($returnUrlOk, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                    new SoapVar($returnUrlFault, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                            ), SOAP_ENC_OBJECT);

    $request->postdata = $postdata;

    return $request;
}


function egopayGetOrderStatus($orderId) {
    $status = new get_status();
    $order = new OrderID();
    $order->shop_id = (int) get_option('egopay_shop_id');
    $order->number = $orderId;
    $status->order = $order;
    return $status;
}


add_action('init', 'nzshpcrt_egopay_callback');
add_action('nzshpcrt_egopay_cron', 'egopayUpdateStatuses');

?>
