<p><?php echo $donationDescription ?></p>

<?php if ($errors != false) { ?>
    <p style="color:#f82"><?php echo $errors ?></p>
<?php } ?>

<?php if ($thanks != false) { ?>
    <p style="color:#282;font-Weight:bold"><?php echo $thanks ?></p>
<?php } else { ?>

    <div class="donation-form" style="position:relative;overflow:hidden">
        <form action="<?php echo $pageUrl ?>" method="post">
            <div style="float:left;">
                <table class="donation-table donation-first">
                    <tr>
                        <td><?php echo __('First Name', 'egopay_donation') ?><span style="color:#f82">*</span>:</td>
                        <td><input type="text" name="fname" value="<?php echo htmlspecialchars($fname) ?>" /></td>
                        <td style="text-align:right"><?php echo __('Donation Amount', 'egopay_donation') ?><span style="color:#f82">*</span>:</td>
                        <td><input style="width:100px;" type="text" name="amount" value="<?php echo htmlspecialchars($amount) ?>" /> &nbsp; <?php echo __('RUB', 'egopay_donation') ?></td>
                    </tr>
                    <tr>
                        <td><?php echo __('Last Name', 'egopay_donation') ?><span style="color:#f82">*</span>:</td>
                        <td><input type="text" name="lname" value="<?php echo htmlspecialchars($lname) ?>" /></td>
                        <td rowspan="4" style="vertical-align:top;text-align:right"><?php echo __('Donation Message', 'egopay_donation') ?>:</td>
                        <td rowspan="4">
                            <textarea name="message" rows="8" cols="22"><?php echo $message ?></textarea>
                        </td>
                    </tr>
                    <tr>
                        <td><?php echo __('Address', 'egopay_donation') ?>:</td>
                        <td><input type="text" name="address" value="<?php echo htmlspecialchars($address) ?>" /></td>
                    </tr>
                    <tr>
                        <td><?php echo __('Phone number', 'egopay_donation') ?>:</td>
                        <td><input type="text" name="phone" value="<?php echo htmlspecialchars($phone) ?>" /></td>
                    </tr>
                    <tr>
                        <td><?php echo __('E-mail', 'egopay_donation') ?><span style="color:#f82">*</span>:</td>
                        <td><input type="text" name="email" value="<?php echo htmlspecialchars($email) ?>" /></td>
                    </tr>
                    <?php if ($recEnabled === 'true') { ?>
                        <tr>
                            <td colspan="4">
                                <label><input type="checkbox" name="rec" value="true" <?php if ($rec) { ?>checked="checked"<?php } ?> /><?php echo $recCaption ?></label>
                            </td>
                        </tr>
                    <?php } ?> 
                    <tr>
                        <td colspan="3"><p style="line-height:37px"><span style="color:#f82">*</span> - <?php echo __('required fields', 'egopay_donation') ?></p></td>
                        <td>
                            <input type="submit" name="submit" value="<?php echo __('Donate', 'egopay_donation') ?>" class="donation-submission" />
                        </td>
                    </tr>
                </table>
            </div>
        </form>
    </div>

<?php 
    }


    if (!empty($donors)) {
?>
<div style="clear:both;">
    <h2><?php echo __('Donors', 'egopay_donation') ?></h2>
    <p><?php echo __('The following people have generously given donations', 'egopay_donation') ?></p>
    <?php
        $color = false;
        foreach ($donors as $d) {
            $color = !$color;
            ?>
                <div style="background-color:<?php echo ($color ? '#C8E7E7' : '#F8E7E7') ?>;padding:4px;position:relative;overflow:hidden" class="donor-block">
                    <div style="float:left;margin-right:10px;">
                        <img alt="" src="http://www.gravatar.com/avatar/<?php echo md5(strtolower(trim($d->email))) ?>?s=40&amp;d=mm" class="avatar avatar-40 photo" height="40" width="40" />
                    </div>
                    <div style="margin-left:50px">
                        <strong><?php echo htmlspecialchars($d->fname) ?> <?php echo htmlspecialchars($d->lname) ?></strong> <?php echo date('d.m.Y H:i', $d->time) ?>
                        <br /><?php echo htmlspecialchars($d->message) ?>
                    </div>
                </div>
            <?php
        }
    ?>
    <div style="clear:both;"></div>
</div>
<?php
    }
?>
