<style type="text/css">
<!--
    .error {
        background: lightcoral;
        border: 1px solid #e64f69 !important;
        margin: 1em 5% 10px !important;
        padding: 0 1em 0 1em !important;
    }
    .center {
        text-align: center;
    }
    .right {
        text-align: right;
    }
    .left {
        text-align: left;
    }
    .top {
        vertical-align: top;
    }
    .bold {
        font-weight: bold;
    }
    .private {
        color: #e64f69;
    }
//-->
</style>
<script>
    function showMessage(id) {
        var td = document.getElementById('m' + id);
        for (var i = 0; i < td.children.length; i++) {
            if (td.children[i].tagName.toLowerCase() === 'div') {
                td.children[i].style.display = 'block';
            } else {
                td.children[i].style.display = 'none';
            }
        }
    }
</script>
<div class="wrap">
    <h2><?php echo __('Donors list', 'egopay_donation') ?></h2>
    <table class="widefat page" width="100%" cellpadding="3" cellspacing="3">
        <thead>
            <tr>
                <th class="manage-column" scope="col"><?php echo __('Transaction ID', 'egopay_donation') ?></th>
                <th class="manage-column" scope="col"><?php echo __('Name', 'egopay_donation') ?></th>
                <th class="manage-column" scope="col"><?php echo __('Address', 'egopay_donation') ?></th>
                <th class="manage-column" scope="col"><?php echo __('Message', 'egopay_donation') ?></th>
                <th class="manage-column" scope="col"><?php echo __('E-mail', 'egopay_donation') ?></th>
                <th class="manage-column" scope="col"><?php echo __('Phone', 'egopay_donation') ?></th>
                <th class="manage-column" scope="col"><?php echo __('Amount', 'egopay_donation') ?></th>
                <th class="manage-column" scope="col"><?php echo __('Date', 'egopay_donation') ?></th>
                <th class="manage-column" scope="col"><?php echo __('Status', 'egopay_donation') ?></th>
                <th class="manage-column" scope="col"><?php echo __('Visibility', 'egopay_donation') ?></th>
            </tr>
        </thead>
        <tbody>
        <?php
            if (!empty($donors)) {
                foreach ($donors as $d) {
                    ?>
                    <tr>
                        <td><?php echo $d->id ?></td>
                        <td><?php echo htmlspecialchars($d->fname . ' ' . $d->lname) ?></td>
                        <td><?php echo htmlspecialchars($d->address) ?></td>
                        <td id="m<?php echo $d->id ?>">
                            <?php
                                if (!empty($d->message)) {
                            ?>
                                <div style="display:none"><?php echo htmlspecialchars($d->message) ?></div>
                                <span><?php echo substr(htmlspecialchars($d->message), 0, 15) ?>...</span>
                                <a onclick="showMessage(<?php echo $d->id ?>)"><?php echo __('View all') ?></a>
                            <?php
                                }
                            ?>
                        </td>
                        <td><?php echo '<a href="mailto:', htmlspecialchars($d->email), '">', htmlspecialchars($d->email), '</a>' ?></td>
                        <td><?php echo htmlspecialchars($d->phone) ?></td>
                        <td><?php echo $d->amount ?></td>
                        <td><?php echo date('d.m.Y H:i', $d->time) ?></td>
                        <td><?php echo $d->status ?></td>
                        <td><?php
                                if ($d->visible == 1) {
                                    echo '<a href="', $adminUrl, 'admin.php?page=egopay_donation&du=1&visible=0&id=', $d->id, '">', __('Visible'), '</a>';
                                } else if ($giver->visible == 0) {
                                    echo '<a href="', $adminUrl, 'admin.php?page=egopay_donation&du=1&visible=1&id=', $d->id, '">', __('Invisible'), '</a>';
                                }
                            ?>
                        </td>
                    </tr>
                    <?php
                }
            }
        ?>
        </tbody>
    </table>
</div>