<?php
/*
Plugin Name: Egopay Payments
Description: Pay via credit cards
Version: 0.0.8
*/

$pluginDir = basename(dirname(__FILE__));
load_plugin_textdomain('egopay_donation', 'wp-content/plugins/' . $pluginDir . '/languages', $pluginDir . '/languages');

global $wpdb;
define('WP_EGOPAY_DONATION_TABLE', $wpdb->prefix . 'egopay_donations');
define('EGOPAY_VERSION', '0.0.8');
define('THIS_PLUGIN_DIR', WP_PLUGIN_DIR . '/' . $pluginDir);

add_filter('the_content', 'egopayShowDonation');
add_filter('the_excerpt', 'egopayShowDonation');
add_filter('the_content_rss', 'egopayShowDonation');
add_filter('the_excerpt_rss', 'egopayShowDonation');

add_action('admin_notices', 'egopayDonationWelcome');
add_action('admin_menu', 'egopayDonationMenu');

add_action('egopay_donation_cron', 'egopayUpdateStatuses');

register_activation_hook(__FILE__, 'egopayDonationInstall');




function egopayDonationFetch($template, $vars = array()) {
    ob_start();
    try {
        extract($vars);
        include(THIS_PLUGIN_DIR . '/templates/' . $template . '.php');
        $output = ob_get_contents();
    } catch (Exception $e) {
        $output = false;
    }
    ob_end_clean();
    return $output;
}


function egopayDonationWelcome() {
    if (get_option('egopay_donation_fresh') == 1) {
        echo egopayDonationFetch('welcome');
        update_option('egopay_donation_fresh', '0');
    }
}

function egopayDonationInstall() {
    global $wpdb;
    if (get_option('egopay_donation_version') != EGOPAY_VERSION) {

        $tableSql = "CREATE TABLE IF NOT EXISTS " . WP_EGOPAY_DONATION_TABLE . " (
            `id` int(8) NOT NULL auto_increment,
            `fname` varchar(255) character set utf8 NOT NULL,
            `lname` varchar(255) character set utf8 NOT NULL,
            `address` text character set utf8 NOT NULL default '',
            `phone` varchar(255) character set utf8 NOT NULL,
            `email` varchar(255) character set utf8 NOT NULL,
            `amount` decimal(11, 2) unsigned NOT NULL DEFAULT '0.00',
            `visible` tinyint(1) NOT NULL default '0',
            `message` text character set utf8 NOT NULL,
            `time` bigint(11) NOT NULL,
            `status` enum('Registered', 'Processed', 'Payed', 'Canceled') NOT NULL,
            PRIMARY KEY (id)
            ) ENGINE=MyISAM DEFAULT CHARSET=utf8;";
        $wpdb->get_results($tableSql);

        update_option('egopay_donation_fresh', '1');
        update_option('egopay_donation_url', '');
        update_option('egopay_donation_shop_id', '');
        update_option('egopay_donation_shop_id_rec', '');
        update_option('egopay_donation_login', '');
        update_option('egopay_donation_password', '');
        update_option('egopay_donation_description', '');
        update_option('egopay_donation_typename', '');
        update_option('egopay_donation_name', '');
        update_option('egopay_donation_percentage', '');
        update_option('egopay_donation_rec_enabled', false);
        update_option('egopay_donation_rec_scheme', 'default');
        update_option('egopay_donation_rec_caption', __('Make a regular donation', 'egopay_donation'));
        update_option('egopay_donation_version', EGOPAY_VERSION);
    }
}

function egopayDonationMenu() {
    if (function_exists('add_menu_page')) {
        add_menu_page(__('Egopay Payments', 'egopay_donation'), __('Egopay Payments', 'egopay_donation'), 'manage_options', 'egopay_donation', 'egopayDonationDonors');
    }
    if (function_exists('add_submenu_page')) {
        add_submenu_page('egopay_donation', __('Payments', 'egopay_donation'), __('Payments', 'egopay_donation'), 'manage_options', 'egopay_donation', 'egopayDonationDonors');
        add_submenu_page('egopay_donation', __('Options', 'egopay_donation'), __('Options', 'egopay_donation'), 'manage_options', 'egopay_donation_config', 'egopayDonationConfig');
    }
}

function egopayDonationConfig() {
    if (isset($_POST['egopay_donation_url'])) {
        update_option('egopay_donation_url', $_POST['egopay_donation_url']);
        update_option('egopay_donation_shop_id', $_POST['egopay_donation_shop_id']);
        update_option('egopay_donation_shop_id_rec', $_POST['egopay_donation_shop_id_rec']);
        update_option('egopay_donation_login', $_POST['egopay_donation_login']);
        update_option('egopay_donation_password', $_POST['egopay_donation_password']);
        update_option('egopay_donation_description', $_POST['egopay_donation_description']);
        update_option('egopay_donation_typename',  $_POST['egopay_donation_typename']);
        update_option('egopay_donation_name',  $_POST['egopay_donation_name']);
        update_option('egopay_donation_percentage',  $_POST['egopay_donation_percentage']);
        update_option('egopay_donation_rec_enabled', $_POST['egopay_donation_rec_enabled']);
        update_option('egopay_donation_rec_scheme', $_POST['egopay_donation_rec_scheme']);
        update_option('egopay_donation_rec_caption', $_POST['egopay_donation_rec_caption']);

        echo egopayDonationFetch('settings_update');
    }

    echo egopayDonationFetch('settings', array(
        'adminUrl' => admin_url(),
        'shopId' => (int) get_option('egopay_donation_shop_id'),
        'shopIdRec' => (int) get_option('egopay_donation_shop_id_rec'),
        'url' => get_option('egopay_donation_url'),
        'login' => get_option('egopay_donation_login'),
        'password' => get_option('egopay_donation_password'),
        'description' => get_option('egopay_donation_description'),
        'typename' => get_option('egopay_donation_typename'),
        'name' => get_option('egopay_donation_name'),
        'percentage' => get_option('egopay_donation_percentage'),
        'rec_enabled' => (bool) get_option('egopay_donation_rec_enabled', false),
        'rec_scheme' => get_option('egopay_donation_rec_scheme', 'default'),
        'rec_caption' => get_option('egopay_donation_rec_caption', __('Make a regular donation', 'egopay_donation'))
    ));
}


function egopayDonationDonors() {
    global $wpdb;

    if (isset($_GET['du'])) {
        if (isset($_GET['visible'])) {
            $visible = $_GET['visible'] == 1 ? 1 : 0;
            $wpdb->query('UPDATE ' . WP_EGOPAY_DONATION_TABLE . ' SET visible = ' . $visible . ' WHERE id = ' . (int) $_GET['id']);
        }
        echo egopayDonationFetch('donor_update');
    }

    $donors = $wpdb->get_results('SELECT id, fname, lname, address, message, email, phone, amount, time, status, visible FROM ' . WP_EGOPAY_DONATION_TABLE . ' ORDER BY id ASC');
    echo egopayDonationFetch('donor_list', array('donors' => $donors, 'adminUrl' => admin_url()));
}


function egopayDonationMain() {
    global $wpdb;

    if (!isset($_GET['donate_action'])) {
        return egopayDonationPage();
    }

    switch ($_GET['donate_action']) {
        case 'register':
            return egopayDonationRegister();
        break;

        case 'success':
            return egopayDonationSuccess();
        break;

        case 'fault':
            return egopayDonationFault();
        break;
        
        default:
            return egopayDonationPage();
        break;
    }
}


function egopayDonationPage($errors = false, $thanks = false) {
    global $wpdb;

    $donors = $wpdb->get_results('SELECT id, fname, lname, address, message, email, phone, amount, time, status, visible FROM ' . WP_EGOPAY_DONATION_TABLE . ' WHERE visible = 1 ORDER BY id DESC');
    return egopayDonationFetch('page', array(
        'donors' => $donors,
        'pageUrl' => add_query_arg('donate_action', 'register', get_permalink()),
        'errors' => $errors,
        'thanks' => $thanks,
        'fname' => isset($_POST['fname']) ? $_POST['fname'] : '',
        'lname' => isset($_POST['lname']) ? $_POST['lname'] : '',
        'address' => isset($_POST['address']) ? $_POST['address'] : '',
        'phone' => isset($_POST['phone']) ? $_POST['phone'] : '',
        'email' => isset($_POST['email']) ? $_POST['email'] : '',
        'amount' => isset($_POST['amount']) ? $_POST['amount'] : '',
        'message' => isset($_POST['message']) ? $_POST['message'] : '',
        'donationDescription' => get_option('egopay_donation_description'),
        'rec' => isset($_POST['rec']) ? (bool) $_POST['rec'] : false,
        'recEnabled' => get_option('egopay_donation_rec_enabled', false),
        'recCaption' => get_option('egopay_donation_rec_caption', __('Make a regular donation', 'egopay_donation'))
    ));
}


function egopayDonationRegister() {
    global $wpdb;

    if (empty($_POST['fname']) || empty($_POST['lname']) || empty($_POST['email']) || empty($_POST['amount'])) {
        $errors = __('Not all required fields have been entered.', 'egopay_donation');
        return egopayDonationPage($errors);
    } else {
        
        $fname = trim($_POST['fname']);
        $lname = trim($_POST['lname']);
        $address = trim($_POST['address']);
        $phone = trim($_POST['phone']);
        $email = trim($_POST['email']);
        $message = trim($_POST['message']);
        if (isset($_POST['rec'])) {
            $recEnabled = (bool) $_POST['rec'];
        } else {
            $recEnabled = false;
        }
        $amount = number_format(str_replace(',', '.', str_replace(' ', '', trim($_POST['amount']))), 2, '.', '');

        if ($amount <= 0) {
            $errors = __('Amount must be greater than 0.', 'egopay_donation');
            return egopayDonationPage($errors);
        }

        $wpdb->query('INSERT INTO ' . WP_EGOPAY_DONATION_TABLE . ' SET fname = "' . htmlspecialchars($fname) . '", lname = "' . htmlspecialchars($lname) . '", address = "' . htmlspecialchars($address) . '", message = "' . htmlspecialchars($message) . '", email = "' . htmlspecialchars($email) . '", phone = "' . htmlspecialchars($phone) . '", amount = "' . $amount. '", time = ' . time() . ', status = "Registered", visible = 0');
        $orderId = $wpdb->insert_id;

        $soapClient = egopayNewSoap();
        $request = egopayPrepareOrder(
            $orderId,
            $amount,
            $lname . ' ' . $fname,
            $email,
            $phone,
            add_query_arg('code', md5($email . $orderId), add_query_arg('order_id', $orderId, add_query_arg('donate_action', 'success', get_permalink()))),
            add_query_arg('code', md5($email . $orderId), add_query_arg('order_id', $orderId, add_query_arg('donate_action', 'fault', get_permalink()))),
            $recEnabled
        );
        try {
            $info = $soapClient->register($request);
            return egopayDonationFetch('redirect', array('url' => $info->redirect_url . '?session=' . $info->session));
        } catch (SoapFault $fault) {
            $errors = __('Error has occured. Please, contact support service and provide error code below.', 'egopay_donation') . '<br />' . $fault->faultstring;
            return egopayDonationPage($errors);
        } catch (Exception $e) {
            $errors = __('Error has occured. Please, contact support service and provide error code below.', 'egopay_donation') . '<br />' . $e->__toString();
            return egopayDonationPage($errors);
        }

    }
}


function egopayDonationSuccess() {
    global $wpdb;

    if (!isset($_GET['order_id']) || !isset($_GET['code'])) {
        $errors = __('Wrong transaction number or verification code.', 'egopay_donation');
        return egopayDonationPage($errors);
    } else {
        $orderId = (int) $_GET['order_id'];
        $order = $wpdb->get_row('SELECT id, status, email FROM ' . WP_EGOPAY_DONATION_TABLE . ' WHERE id = ' . $orderId . ' AND status NOT IN ("Payed", "Canceled")');
        if ($order && ($_GET['code'] == md5($order->email . $orderId))) {
            $soapClient = egopayNewSoap();
            $objStatus = egopayGetOrderStatus($orderId);
            $info = $soapClient->get_status($objStatus);
            try {
                switch ($info->status) {
                    case 'acknowledged':
                    case 'not_acknowledged':
                    case 'authorized':
                        $wpdb->query('UPDATE ' . WP_EGOPAY_DONATION_TABLE . ' SET status = "Payed", visible = 1 WHERE id = '. $orderId);
                        $notice = __('Payment accepted', 'egopay_donation');
                        return egopayDonationPage(false, $notice);
                    break;

                    case 'canceled':
                    case 'not_authorized':
                        $wpdb->query('UPDATE ' . WP_EGOPAY_DONATION_TABLE . ' SET status = "Canceled", visible = 0 WHERE id = '. $orderId);
                        $errors = __('Payment has been canceled.', 'egopay_donation');
                        return egopayDonationPage($errors);
                    break;
        
                    default:
                        $wpdb->query('UPDATE ' . WP_EGOPAY_DONATION_TABLE . ' SET status = "Processed", visible = 1 WHERE id = '. $orderId);
                        $notice = __('Your transaction is currently processed.', 'egopay_donation');
                        return egopayDonationPage(false, true);
                    break;
                }
            } catch (SoapFault $fault) {
                if ($fault->faultstring === 'INVALID_ORDER') {
                    $wpdb->query('UPDATE ' . WP_EGOPAY_DONATION_TABLE . ' SET status = "Canceled", visible = 0 WHERE id = '. $orderId);
                    $errors = __('Ttansaction with the current number has not been registered.', 'egopay_donation') . '<br />' . $fault->faultstring;
                } else {
                    $errors = __('Error has occured. Please, contact support service and provide error code below.', 'egopay_donation') . '<br />' . $fault->faultstring;
                }
                return egopayDonationPage($errors);
            } catch (Exception $e) {
                $errors = __('Error has occured. Please, contact support service and provide error code below.', 'egopay_donation') . '<br />' . $e->__toString();
                return egopayDonationPage($errors);
            }
        } else {
            $errors = __('Wrong transaction number or verification code.', 'egopay_donation');
            return egopayDonationPage($errors); 
        }
    }
}


function egopayDonationFault() {
    global $wpdb;

    if (!isset($_GET['order_id']) || !isset($_GET['code'])) {
        $errors = __('Wrong transaction number or verification code.', 'egopay_donation');
        return egopayDonationPage($errors);
    } else {
        $orderId = (int) $_GET['order_id'];
        $order = $wpdb->get_row('SELECT id, status, email FROM ' . WP_EGOPAY_DONATION_TABLE . ' WHERE id = ' . $orderId . ' AND status NOT IN ("Payed", "Canceled")');
        if ($order && ($_GET['code'] == md5($order->email . $orderId))) {
            $wpdb->query('UPDATE ' . WP_EGOPAY_DONATION_TABLE . ' SET status = "Canceled", visible = 0 WHERE id = '. $orderId);
            $errors = __('Payment has been canceled.', 'egopay_donation');
            return egopayDonationPage($errors);
        } else {
            $errors = __('Wrong transaction number or verification code.', 'egopay_donation');
            return egopayDonationPage($errors); 
        }
    }
}



function egopayUpdateStatuses() {
    global $wpdb;

    if ($orders = $wpdb->get_results('SELECT id FROM ' . WP_EGOPAY_DONATION_TABLE . ' WHERE status NOT IN ("Payed", "Canceled")')) {
        $soapClient = egopayNewSoap();
        foreach ($orders as $o) {
            $objStatus = egopayGetOrderStatus($o->id);
            $info = $soapClient->get_status($objStatus);
            try {
                switch ($info->status) {
                    case 'acknowledged':
                    case 'not_acknowledged':
                    case 'authorized':
                        $wpdb->query('UPDATE ' . WP_EGOPAY_DONATION_TABLE . ' SET status = "Payed", visible = 1 WHERE id = '. $o->id);
                    break;

                    case 'canceled':
                    case 'not_authorized':
                        $wpdb->query('UPDATE ' . WP_EGOPAY_DONATION_TABLE . ' SET status = "Canceled", visible = 0 WHERE id = '. $o->id);
                    break;
                }
                echo 'Статус заказа № ', $o->id, ': ', $info->status, "\r\n";

            } catch (SoapFault $fault) {
                echo 'Ошибка при проверке статуса заказа № ', $o->id, ': ', $fault->faultcode , '-' , $fault->faultstring, "\r\n";
                if ($fault->faultstring === 'INVALID_ORDER') {
                    // заказ с таким номером не зарегистрирован
                    $wpdb->query('UPDATE ' . WP_EGOPAY_DONATION_TABLE . ' SET status = "Canceled", visible = 0 WHERE id = '. $o->id);
                }
            } catch (Exception $e) {
                echo 'Ошибка при проверке статуса заказа № ', $o->id, ': PHP Error', "\r\n";
            }
        }
    }
    
}


function egopayShowDonation($content) {
    if (strpos($content, '{EGOPAY_DONATION}') !== false) {
        $rendered = egopayDonationMain();
        $content = str_replace('{EGOPAY_DONATION}', $rendered, $content);
    }
    return $content;
}


function egopayNewSoap() {
    require_once(THIS_PLUGIN_DIR . '/orderv2.php');

    return new orderv2(null, array(
        'location' => get_option('egopay_donation_url'),
        'uri'      => 'http://www.sirena-travel.ru',
        'login'    => get_option('egopay_donation_login'),
        'password' => get_option('egopay_donation_password'),
        'trace'    => 0,
        'features' => SOAP_SINGLE_ELEMENT_ARRAYS,
        'connection_timeout' => 12));
}

/* подготавливаем данные заказа для отправки */
function egopayPrepareOrder($orderId, $orderSum, $userName, $userEmail, $userPhone, $okUrl, $faultUrl, $rec) {
    $request = new register();
    $order = new OrderID(); 
    $order->shop_id = (int) get_option('egopay_donation_shop_id');
    echo $order->number = $orderId;
    $cost = new Amount();
    $cost->amount = $orderSum;
    $cost->currency = 'RUB';
    $customer = new CustomerInfo();
    $customer->name = $userName;
    $customer->email = $userEmail;
    $customer->phone = $userPhone;
    $description = new OrderInfo();
    $description->paytype = 'card';
    $arItems = array();

    $item = new OrderItem();
    $item->number = $orderId;
    $item->amount = $cost;
    $item->typename = get_option('egopay_donation_typename');
    $item->quanity = 1;
    $item->name = get_option('egopay_donation_name');
    $tax_percentage = (int) get_option('egopay_donation_percentage');
    $tax_value = $orderSum * $tax_percentage / (100 + $tax_percentage);
    $itemTaxes = array(
                new SoapVar("<tax type='vat'><percentage>".get_option('egopay_donation_percentage')."</percentage><amount><currency>RUB</currency><amount>".round($tax_value, 2)."</amount></amount></tax>", XSD_ANYXML),
            );
    $item->taxes = new SoapVar($itemTaxes, SOAP_ENC_OBJECT);

    $arItems[] = new SoapVar($item, SOAP_ENC_OBJECT, null, null, 'OrderItem');

    $description->sales = new SoapVar(
                $arItems,
                SOAP_ENC_OBJECT
            );
    $language = new PostEntry();
    $language->name = 'Language';
    if (get_locale() == 'ru_RU') {
        $language->value = 'ru';
    } else {
        $language->value = 'en';
    }
    $returnUrlOk = new PostEntry();
    $returnUrlOk->name = 'ReturnURLOk';
    $returnUrlOk->value = $okUrl;
    $returnUrlFault = new PostEntry();
    $returnUrlFault->name = 'ReturnURLFault';
    $returnUrlFault->value = $faultUrl;
    $cardtype = new PostEntry();
    $cardtype->name = 'ChoosenCardType';
    $cardtype->value = 'VI';
    $request->order = $order;
    $request->cost = $cost;
    $request->customer = $customer;
    $request->description = $description;

    $postvars = array(
        new SoapVar($language, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
        new SoapVar($cardtype, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
        new SoapVar($returnUrlOk, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
        new SoapVar($returnUrlFault, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
    );

    if (get_option('egopay_donation_rec_enabled', 'false') && $rec) {
        $recurring = new PostEntry();
        $recurring->name = 'Recurring';
        $recurring->value = get_option('egopay_donation_rec_scheme', 'default');
        $postvars[] = new SoapVar($recurring, SOAP_ENC_OBJECT, null, null, 'PostEntry');
        $order->shop_id = (int) get_option('egopay_donation_shop_id_rec');
    }

    $request->postdata = new SoapVar($postvars, SOAP_ENC_OBJECT);

    return $request;
}

function egopayGetOrderStatus($orderId) {
    $status = new get_status();
    $order = new OrderID();
    $order->shop_id = (int) get_option('egopay_donation_shop_id');
    $order->number = $orderId;
    $status->order = $order;
    return $status;
}
?>
