<?php
/**
 * Plugin Name: Jigoshop Egopay
 * Plugin URI: http://egopay.ru/
 * Description: Egopay gateway for Jigoshop.
 * Author: Egopay
 * Author URI: http://egopay.ru/
 * Version: 0.2
 * License: GPLv2 or later
 * Text Domain: jigoegopay
 * Domain Path: /languages/
 */

function jigoegopay_fetch($template, $vars = array()) {
    extract($vars);
    ob_start();
    try {
        include(WP_PLUGIN_DIR . '/' . dirname(plugin_basename(__FILE__)) . '/templates/' . $template . '.php');
        $output = ob_get_contents();
    } catch (Exception $e) {
        $output = false;
    }
    ob_end_clean();
    return $output;
}


/* сообщение о неустановленном JigoShop */
function jigoegopay_fallback_notice() {
    echo jigoegopay_fetch('error', array('error' => __('JigoShop Egopay Plugin depends on <a href="http://wordpress.org/extend/plugins/jigoshop/">JigoShop</a>.', 'jigoegopay')));
}

/* загружаем наш плагин  */
add_action('plugins_loaded', 'jigoegopay_gateway_load', 0);


function jigoegopay_gateway_load() {
    /* если нет jigoshop выводим сообщение */
    if (!class_exists('jigoshop_payment_gateway')) {
        add_action('admin_notices', 'jigoegopay_fallback_notice');
        return;
    }

    require_once(WP_PLUGIN_DIR . '/' . dirname(plugin_basename(__FILE__)) . '/orderv2.php');

    load_plugin_textdomain('jigoegopay', false, dirname(plugin_basename(__FILE__)) . '/languages/');

    /* регистрируем наш платёжный метод */
    add_filter('jigoshop_payment_gateways', 'jigoegopay_add_egopay_gateway', 10);

    function jigoegopay_add_egopay_gateway($methods) {
        $methods[] = 'Egopay_Gateway';
        return $methods;
    }

    class Egopay_Gateway extends jigoshop_payment_gateway {

        public function __construct() {

            parent::__construct();

            $this->id = 'egopay';
            $this->has_fields = false;

            $this->enabled = Jigoshop_Base::get_options()->get_option('jigoegopay_egopay_enabled');
            $this->title = Jigoshop_Base::get_options()->get_option('jigoegopay_egopay_title');
            $this->description = Jigoshop_Base::get_options()->get_option('jigoegopay_egopay_description');

            /* переменные */
            $this->shop_id = Jigoshop_Base::get_options()->get_option('jigoegopay_egopay_shop_id');
            $this->shop_url = Jigoshop_Base::get_options()->get_option('jigoegopay_egopay_shop_url');
            $this->shop_login = Jigoshop_Base::get_options()->get_option('jigoegopay_egopay_shop_login');
            $this->shop_password = Jigoshop_Base::get_options()->get_option('jigoegopay_egopay_shop_password');
            
            /* действия */
            add_action('init', array(&$this, 'check_response'));
            add_action('receipt_egopay', array(&$this, 'receipt_page'));
            add_action('jigoshop_before_order_summary_details', array(&$this, 'egopay_showmessage'));
            add_action('egopay_cron', array(&$this, 'egopay_cron'));
        }

        /* настройки переменных */
        protected function get_default_options() {
            $defaults = array();

            $defaults[] = array(
                'name' => __('Egopay', 'jigoegopay'),
                'type' => 'title',
                'desc' => __('Egopay payment system.', 'jigoegopay')
            );

            // List each option in order of appearance with details.
            $defaults[] = array(
                'name' => __('Enable Egopay', 'jigoegopay'),
                'desc' => '',
                'tip' => '',
                'id' => 'jigoegopay_egopay_enabled',
                'std' => 'yes',
                'type' => 'checkbox',
                'choices' => array(
                    'no' => __('No', 'jigoegopay'),
                    'yes' => __('Yes', 'jigoegopay')
                )
            );

            $defaults[] = array(
                'name' => __('Method Title', 'jigoegopay'),
                'desc' => '',
                'tip' => __('This controls the title which the user sees during checkout.', 'jigoegopay'),
                'id' => 'jigoegopay_egopay_title',
                'std' => __('Egopay', 'jigoegopay'),
                'type' => 'text'
            );

            $defaults[] = array(
                'name' => __('Description', 'jigoegopay'),
                'desc' => '',
                'tip' => __('This controls the description which the user sees during checkout.', 'jigoegopay'),
                'id' => 'jigoegopay_egopay_description',
                'std' => __('Pay via Egopay', 'jigoegopay'),
                'type' => 'longtext'
            );

            $defaults[] = array(
                'name' => __('Egopay Shop ID', 'jigoegopay'),
                'desc' => '',
                'tip' => __('Please enter your Shop ID in Egopay system.', 'jigoegopay'),
                'id' => 'jigoegopay_egopay_shop_id',
                'std' => '',
                'type' => 'text'
            );

            $defaults[] = array(
                'name' => __('Egopay Gateway Address', 'jigoegopay'),
                'desc' => '',
                'tip' => __('Please enter Egopay gateway URL-address.', 'jigoegopay'),
                'id' => 'jigoegopay_egopay_shop_url',
                'std' => '',
                'type' => 'text'
            );

            $defaults[] = array(
                'name' => __('Egopay login', 'jigoegopay'),
                'desc' => '',
                'tip' => __('Please enter your login in Egopay system.', 'jigoegopay'),
                'id' => 'jigoegopay_egopay_shop_login',
                'std' => '',
                'type' => 'text'
            );

            $defaults[] = array(
                'name' => __('Egopay password', 'jigoegopay'),
                'desc' => '',
                'tip' => __('Please enter your password in Egopay system.', 'jigoegopay'),
                'id' => 'jigoegopay_egopay_shop_password',
                'std' => '',
                'type' => 'text'
            );


            return $defaults;
        }

        /* подготавливаем новое soap-соединение */
        function newSoap() {
            return new orderv2(null, array(
                'location' => $this->shop_url,
                'uri'      => 'http://www.sirena-travel.ru',
                'login'    => $this->shop_login,
                'password' => $this->shop_password,
                'trace'    => 0,
                'features' => SOAP_SINGLE_ELEMENT_ARRAYS,
                'connection_timeout' => 12));
        }

        /* подготавливаем данные заказа для отправки */
        function prepareOrder($orderId, $orderSum, $userId, $userName, $userEmail, $userPhone, $okUrl, $faultUrl) {
            $request = new register_online();
            $order = new OrderID(); 
            $order->shop_id = $this->shop_id;
            $order->number = $orderId;
            $cost = new Amount();
            $cost->amount = $orderSum;
            $cost->currency = 'RUB';
            $customer = new CustomerInfo();
            $customer->id = $userId;
            $customer->name = $userName;
            $customer->email = $userEmail;
            $customer->phone = $userPhone;
            $description = new OrderInfo();
            $description->paytype = 'card';
            $language = new PostEntry();
            $language->name = 'Language';
            $language->value = 'ru';
            $returnUrlOk = new PostEntry();
            $returnUrlOk->name = 'ReturnURLOk';
            $returnUrlOk->value = $okUrl;
            $returnUrlFault = new PostEntry();
            $returnUrlFault->name = 'ReturnURLFault';
            $returnUrlFault->value = $faultUrl;
            $cardtype = new PostEntry();
            $cardtype->name = 'ChoosenCardType';
            $cardtype->value = 'VI';
            $request->order = $order;
            $request->cost = $cost;
            $request->customer = $customer;
            $request->description = $description;

            $postdata = new SoapVar(array(
                                            new SoapVar($language, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                            new SoapVar($cardtype, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                            new SoapVar($returnUrlOk, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                            new SoapVar($returnUrlFault, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                    ), SOAP_ENC_OBJECT);

            $request->postdata = $postdata;

            return $request;
        }

        /* подготавливаем структуру для запроса статуса заказа */
        public function getOrderStatus($orderId) {
            $status = new get_status();
            $order = new OrderID();
            $order->shop_id = $this->shop_id;
            $order->number = $orderId;
            $status->order = $order;
            return $status;
        }

        /* выводим описание нашей платёжной системы */
        function payment_fields() {
            if ($this->description) {
                echo wpautop(wptexturize($this->description));
            }
        }

        function process_payment($order_id) {
            $order = new jigoshop_order($order_id);

            return array(
                'result' => 'success',
                'redirect' => add_query_arg('order', $order->id, add_query_arg('key', $order->order_key, get_permalink(jigoshop_get_page_id('pay'))))
            );
        }


        /* выводим кнопку и регистрируем заказ */
        function receipt_page($order_id) {
            $order = new jigoshop_order($order_id);

            $soapClient = $this->newSoap();
            $request = $this->prepareOrder(
                $order->id,
                $this->fix_money_format($order->order_total),
                $order->user_id,
                $order->billing_last_name . ' ' . $order->billing_first_name,
                $order->billing_email,
                $order->billing_phone,
                add_query_arg('egopay_status', 'ok', add_query_arg('key', $order->order_key, add_query_arg('order', $order->id, trailingslashit(get_bloginfo('url'))))),
                add_query_arg('egopay_status', 'fault', add_query_arg('key', $order->order_key, add_query_arg('order', $order->id, trailingslashit(get_bloginfo('url')))))
            );
            try {
                $info = $soapClient->register_online($request);
                // всё ок, зарегистрировали, перенаправляем на платёжную систему
                echo jigoegopay_fetch('register', array(
                    'form_url' => esc_url($info->redirect_url . '?session=' . $info->session),
                    'cancel_url' => esc_url($order->get_cancel_order_url())

                ));
            } catch (SoapFault $fault) {
                echo jigoegopay_fetch('register.error', array(
                    'url' => add_query_arg('order', $order->id, add_query_arg('key', $order->order_key, get_permalink(jigoshop_get_page_id('pay'))))
                ));
            }
        }


        function fix_money_format($value) {
            $decimal_sep = Jigoshop_Base::get_options()->get_option('jigoshop_price_decimal_sep');
            $thousand_sep = Jigoshop_Base::get_options()->get_option('jigoshop_price_thousand_sep');

            if ($thousand_sep == '.' && $decimal_sep == ',') {
                $value = str_replace('.', '', $value);
                $value = str_replace(',', '.', $value);
            }

            $value = number_format($value, 2, '.', '');

            return $value;
        }

        function egopay_showmessage() {
            if (isset($_GET['error'])) {
                switch ($_GET['error']) {
                    case 'fault':
                        echo jigoegopay_fetch('error', array('error' => __('Payment has failed.', 'jigoegopay')));
                    break;

                    case 'invalid':
                        echo jigoegopay_fetch('error', array('error' => __("Order with this number has not registered. Please, contact shop's support service.", 'jigoegopay')));
                    break;

                    case 'notregistered':
                        echo jigoegopay_fetch('error', array('error' => __('Wrong order number or key.', 'jigoegopay')));
                    break;
                }
            }
        }


        public function check_response() {
            if (is_admin()) {
                return;
            }

            if (isset($_GET['egopay_status'])) {
                $order = new jigoshop_order((int) $_GET['order']);
                if ($order->order_key === $_GET['key']) {
                    if ($_GET['egopay_status'] == 'ok') {
                        $soapClient = $this->newSoap();
                        $objStatus = $this->getOrderStatus($order->id);
                        // получаем статуса заказа от платёжной системы
                        $info = $soapClient->get_status($objStatus);
                        try {
                            switch ($info->status) {
                                case 'acknowledged':
                                case 'not_acknowledged':
                                case 'authorized':
                                    $order->add_order_note(__('Payment completed.', 'jigoegopay'));
                                    $order->payment_complete();
                                    wp_redirect(get_permalink(jigoshop_get_page_id('thanks')));
                                    die();
                                break;

                                case 'canceled':
                                case 'not_authorized':
                                    $order->update_status('cancelled', __('Payment canceled by Egopay.', 'jigoegopay'));
                                break;
                    
                                default:
                                break;
                            }
                        } catch (SoapFault $fault) {
                            if ($fault->faultstring === 'INVALID_ORDER') {
                                $order->update_status('cancelled', __('Payment canceled by Egopay.', 'jigoegopay'));
                            }
                        }
                    }
                    if ($_GET['egopay_status'] == 'fault') {
                        wp_redirect(add_query_arg('error', 'fault', add_query_arg('order', $order->id, get_permalink(jigoshop_get_page_id('view_order')))));
                        die();
                    }
                } else {
                    wp_redirect(add_query_arg('error', 'wrong_id', add_query_arg('order', $_GET['order'], get_permalink(jigoshop_get_page_id('view_order')))));
                    die();
                }
                wp_redirect(add_query_arg('order', $_GET['order'], get_permalink(jigoshop_get_page_id('view_order'))));
                die();
            }
        }

        function egopay_cron() {
            $args = array(
                'numberposts' => -1,
                'meta_key' => '',
                'meta_value' => '',
                'post_type' => 'shop_order',
                'post_status' => 'publish',
                'tax_query' => array(
                    array(
                        'taxonomy' => 'shop_order_status',
                        'terms' => array('pending'),
                        'field' => 'slug',
                        'operator' => 'IN'
                    )
                ),
                'meta_query' => array(
                    array(
                        'key' => 'order_data',
                        'value' => $this->id,
                        'compare' => 'LIKE'
                    )
                )
            );

            $results = get_posts($args);

            if ($results) {
                $soapClient = $this->newSoap();

                foreach ($results as $result) {
                    $order = new jigoshop_order();
                    $order->populate($result);

                    if ($order->payment_method == $this->id) {
                        $objStatus = $this->getOrderStatus($order->id);
                        try {
                            $info = $soapClient->get_status($objStatus);

                            switch ($info->status) {
                                case 'acknowledged':
                                case 'not_acknowledged':
                                case 'authorized':
                                    $order->add_order_note(__('Payment completed.', 'jigoegopay'));
                                    $order->payment_complete();
                                break;

                                case 'canceled':
                                case 'not_authorized':
                                    // оплата заказа не удалась
                                    $order->update_status('cancelled', __('Payment canceled by Egopay.', 'jigoegopay'));
                                break;

                            }
                            echo 'Статус заказа № ', $order->id, ': ', $info->status, "\r\n";

                        } catch (SoapFault $fault) {
                            echo 'Ошибка при проверке статуса заказа № ', $order->id, ': ', $fault->faultcode , '-' , $fault->faultstring, "\r\n";
                            if ($fault->faultstring === 'INVALID_ORDER') {
                                // заказ с таким номером не зарегистрирован
                                $order->update_status('cancelled', __('Payment canceled by Egopay.', 'jigoegopay'));
                            }
                        }
                    }

                    unset($order);
                }
              
            }
        }

    }
}