<?php

/**
 * EgoPay for Simpla CMS
 *
 * @copyright 	2012 Shavrin Artem
 * @author 		Shavrin Artem
 *
 * Модуль оплаты EgoPay для Simpla CMS
 *
 */

chdir (dirname(__FILE__) . '/../../');
require_once('EgoPay.php');
$simpla = new EgoPay();

/**
 * проверяем статус заказов
 * запускаем скрипт
 *  php /путь_к_симпла/payment/EgoPay/callback.php -cron >> /var/log/simpla_cron.log
 *
 */
if (!empty($argv[1]) && ($argv[1] == '-cron')) {
	// пытаемся найти наш модуль	
	$paymentMethods = $simpla->payment->get_payment_methods();
	$ep = false;
	foreach ($paymentMethods as $pm) {
		if ($pm->module === 'EgoPay') {
			$ep = $pm;
		}
	}

	if (!$ep) {
		die('Не найден модуль оплаты EgoPay.');
	}

	// полуаем заказы
	$simpla->paymentMethodId = $ep->id;
	$orders = $simpla->getEgoPayUnpaidOrders();

	// настройки модуля
	$settings = $simpla->payment->get_payment_settings($ep->id);

	$soapClient = $simpla->newSoap($settings);

	$status = new get_status();
	$order = new OrderID();
	$order->shop_id = $settings['shop_id'];

	// пытаемся получить статус заказов
	foreach ($orders as $orderId => $o) {
		$order->number = $orderId;
		$status->order = $order;
		try {
			$info = $soapClient->get_status($status);
			if (!empty($info->error->category) && ($info->error->category != 'system') && ($info->error->code != 'ok')) {
				echo 'Ошибка для заказа № ', $orderId, ': ', $info->error->category, '>', $info->error->code, "\r\n";
			} else {
				if ($info->status === 'acknowledged') {
					// заказ успешно оплачен
					$simpla->orders->update_order(intval($orderId), array('paid' => 1));
				}
				if ($info->status === 'not_authorized') {
					// оплата заказа не удалась
					$simpla->orders->update_order(intval($orderId), array('status' => 3));
				}
				echo 'Статус заказа № ', $orderId, ': ', $info->status, "\r\n";
			}
		} catch (SoapFault $fault) {
			echo 'Ошибка при проверке статуса заказа ' , $fault->faultcode , '-' , $fault->faultstring, "\r\n";
			if ($fault->faultstring === 'INVALID_ORDER') {
				// заказ с таким номером не зарегистрирован, отменяем
				$simpla->orders->update_order(intval($orderId), array('status' => 3));
			}
		}
	}
}


// пытаемся зарегистрировать заказ
if (!empty($_POST['register_order'])) {
	$returnUrl = $simpla->config->root_url . '/payment/EgoPay/callback.php';

	$simplaOrder = $simpla->orders->get_order((int) $_POST['order_id']);
	$payment_method = $simpla->payment->get_payment_method($simplaOrder->payment_method_id);
	$currency = $simpla->money->get_currency(intval($payment_method->currency_id));
	$payment_settings = $simpla->payment->get_payment_settings($payment_method->id);
	$price = round($simpla->money->convert($simplaOrder->total_price, $payment_method->currency_id, false), 2);

	$soapClient = $simpla->newSoap($payment_settings);
	$request = new register_online();
	$order = new OrderID(); 
	$order->shop_id = $payment_settings['shop_id'];
	$order->number = $simplaOrder->id;       
	$cost = new Amount();
	$cost->amount = $price;
	$cost->currency = $payment_settings['currency'];
	$customer = new CustomerInfo();
	if ($simplaOrder->user_id != 0) {
        $customer->id = $userId;
    }
	$customer->name = $simplaOrder->name;
	$customer->email = $simplaOrder->email;
	$customer->phone = $simplaOrder->phone;
	$description = new OrderInfo();
	$description->paytype = 'card';
	$language = new PostEntry();
	$language->name = 'Language';
	$language->value = $payment_settings['language'];
	$returnUrlOk = new PostEntry();
	$returnUrlOk->name = 'ReturnURLOk';
	$returnUrlOk->value = $returnUrl . '?status=ok&order_id=' . $simplaOrder->url;
	$returnUrlFault = new PostEntry();
	$returnUrlFault->name = 'ReturnURLFault';
	$returnUrlFault->value = $returnUrl . '?status=fault';
	$cardtype = new PostEntry();
	$cardtype->name = 'ChoosenCardType';
	$cardtype->value = $payment_settings['card_type'];
	$request->order = $order;
	$request->cost = $cost;
	$request->customer = $customer;
	$request->description = $description;
	 
	$postdata = new SoapVar(array(
	                                new SoapVar($language, SOAP_ENC_OBJECT, null, null, "PostEntry"),
	                                new SoapVar($cardtype, SOAP_ENC_OBJECT, null, null, "PostEntry"),
	                                new SoapVar($returnUrlOk, SOAP_ENC_OBJECT, null, null, "PostEntry"),
	                                new SoapVar($returnUrlFault, SOAP_ENC_OBJECT, null, null, "PostEntry"),
	                        ), SOAP_ENC_OBJECT);

	$request->postdata = $postdata;
	try {
		$info = $soapClient->register_online($request);
		header('Location: ' . $info->redirect_url . '?session=' . $info->session);
		die();
	} catch (SoapFault $fault) {
		die('В процессе оплаты возникла ошибка: ' . $fault->faultcode . '-' . $fault->faultstring);
	}
}


// возврат от платёжной системы
if (!empty($_GET['status'])) {

	chdir (dirname(__FILE__) . '/../../');
	require_once('view/IndexView.php');

	class EgoPayView extends IndexView {

		public function __construct() {
			parent::__construct();
		}

		function fetch($url, $message = '') {
			$this->design->assign('cart',		$this->cart->get_cart());

			$this->design->assign('categories', $this->categories->get_categories_tree());

			$pages = $this->pages->get_pages(array('visible'=>1));
			$this->design->assign('pages', $pages);

			$this->design->assign('egopay_url', $url);
			$this->design->assign('egopay_message', $message);
			$content = $this->design->smarty->fetch('payment/EgoPay/check.tpl');

			$this->design->assign('content', $content);

			$this->design->assign('module', false);

			$wrapper = $this->design->smarty->getTemplateVars('wrapper');
			if(is_null($wrapper)) {
				$wrapper = 'index.tpl';
			}

			if(!empty($wrapper)) {
				return $this->body = $this->design->fetch($wrapper);
			} else {
				return $this->body = $content;
			}
		}

	}

	$view = new EgoPayView;
	$result = '';

	if (!empty($_GET['order_id'])) {
		if ($simplaOrder = $simpla->orders->get_order($_GET['order_id'])) {
			$orderId = $simplaOrder->id;

			$settings = $simpla->payment->get_payment_settings($simplaOrder->payment_method_id);

			$soapClient = $simpla->newSoap($settings);
			$status = new get_status();
			$order = new OrderID();
			$order->shop_id = $settings['shop_id'];
			$order->number = $simplaOrder->id;
			$status->order = $order;
			try {
				$info = $soapClient->get_status($status);
				if (!empty($info->error->category) && ($info->error->category == 'system') && ($info->error->code == 'ok')) {
					if ($info->status === 'acknowledged') {
						// заказ успешно оплачен
						$simpla->orders->update_order(intval($orderId), array('paid' => 1));
						$result = $view->fetch('/order/' . $simplaOrder->url);
					}
					if ($info->status === 'not_authorized') {
						// оплата заказа не удалась
						$simpla->orders->update_order(intval($orderId), array('status' => 3));
						$result = $view->fetch('/', 'При попытке оплаты заказа произошла ошибка, пожалуйста, подождите...');
					}
				}	
			} catch (SoapFault $fault) {
				if ($fault->faultstring === 'INVALID_ORDER') {
					// заказ с таким номером не зарегистрирован, отменяем
					$simpla->orders->update_order(intval($orderId), array('status' => 3));
					$result = $view->fetch('/', 'При попытке оплаты заказа произошла ошибка, пожалуйста, подождите...');
				}
			}
		} else {
			$result = $view->fetch('/', 'Заказ не найден, пожалуйста, подождите...');
		}
	} else {
		$result = $view->fetch('/', 'Неверный номер заказа, пожалуйста, подождите...');
	}

	header('Content-type: text/html; charset=UTF-8');
	echo $result;

}