<?php

require_once(dirname(__FILE__) . '/../../api/Simpla.php');
require_once(dirname(__FILE__) . '/orderv2.php');

class EgoPay extends Simpla
{	

	public function checkout_form($order_id, $button_text = null)
	{
		if(empty($button_text)) {
			$button_text = 'Перейти к оплате';
		}
			
		$button =	'<form action="' . $this->config->root_url . '/payment/EgoPay/callback.php" method="POST"/>'. 
					'<input type="hidden" name="register_order" value="1" />' .
					'<input type="hidden" name="order_id" value="' . (int) $order_id . '" />' .
					'<input type="submit" class="checkout_button" value="' . $button_text . '">' .
					'</form>';
		return $button;
	}

	// расширяем апи для удобства нахождения заказов нашей платёжной системы
	public $paymentMethodId;
	function getEgoPayUnpaidOrders() {
		$query = $this->db->placehold("SELECT * FROM __orders AS o WHERE paid = 0 and status = 0 and payment_method_id = ?", $this->paymentMethodId);
		$this->db->query($query);
		$orders = array();
		foreach($this->db->results() as $order) {
			$orders[$order->id] = $order;
		}
		return $orders;
	}

	function newSoap($settings) {
		return new orderv2(null, array(	'location' => $settings['location'],
										'uri'      => 'http://www.sirena-travel.ru',
										'login'    => $settings['login'],
										'password' => $settings['password'],
										'trace'    => 0,
										'features' => SOAP_SINGLE_ELEMENT_ARRAYS,
										'connection_timeout' => 12));
	}

}