<?php
class ControllerPaymentEgopay extends Controller {
    protected function index() {
        $this->language->load('payment/egopay');
        
        $this->data['egopay_template'] = 'confirm';
        $this->data['button_confirm'] = $this->language->get('button_confirm');
        
        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/egopay.tpl')) {
            $this->template = $this->config->get('config_template') . '/template/payment/egopay.tpl';
        } else {
            $this->template = 'default/template/payment/egopay.tpl';
        }
        
        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

        $this->render();
    }


    public function register() {
        if (!empty($this->session->data['order_id'])) {
            $this->load->model('checkout/order');
            $orderInfo = $this->model_checkout_order->getOrder($this->session->data['order_id']);

            $this->model_checkout_order->confirm($orderInfo['order_id'], $this->config->get('config_order_status_id'));

            $this->load->model('payment/egopay');
            $soapClient = $this->model_payment_egopay->newSoap($this->config->get('egopay_shop_url'), $this->config->get('egopay_shop_login'), $this->config->get('egopay_shop_password'));
            $request = $this->model_payment_egopay->prepareOrder($this->config->get('egopay_shop_id'), $orderInfo['order_id'], $orderInfo['total'], $orderInfo['customer_id'], $orderInfo['payment_lastname'] . ' ' . $orderInfo['payment_firstname'], $orderInfo['email'], $orderInfo['telephone'], $this->url->link('payment/egopay/status_ok'), $this->url->link('payment/egopay/status_fault'));
            try {
                $info = $soapClient->register_online($request);
                // всё ок, зарегистрировали, перенаправляем на платёжную систему
                $this->redirect($info->redirect_url . '?session=' . $info->session);
            } catch (SoapFault $fault) {
                $this->language->load('payment/egopay');
            
                $this->data['egopay_template'] = 'try_again';
                $this->data['button_try_again'] = $this->language->get('button_try_again');
                $this->data['error_register_fault'] = $this->language->get('error_register_fault');

                $this->egoRender();
            }
        }
    }


    public function status_ok() {
        if (!empty($this->session->data['order_id'])) {
            $this->language->load('payment/egopay');

            $this->load->model('checkout/order');
            $orderInfo = $this->model_checkout_order->getOrder($this->session->data['order_id']);

            $this->load->model('payment/egopay');
            $soapClient = $this->model_payment_egopay->newSoap($this->config->get('egopay_shop_url'), $this->config->get('egopay_shop_login'), $this->config->get('egopay_shop_password'));
            $objStatus = $this->model_payment_egopay->getOrderStatus($this->config->get('egopay_shop_id'), $orderInfo['order_id']);
            try {
                // получаем статуса заказа от платёжной системы
                $info = $soapClient->get_status($objStatus);

                switch ($info->status) {
                    case 'acknowledged':
                    case 'not_acknowledged':
                    case 'authorized':
                        $this->model_checkout_order->update($orderInfo['order_id'], $this->config->get('egopay_order_status_success_id'), 'Egopay status: ' . $info->status, false);
                        $this->redirect($this->url->link('checkout/success'));
                    break;

                    case 'canceled':
                    case 'not_authorized':
                        // оплата заказа не удалась
                        $this->model_checkout_order->update($orderInfo['order_id'], $this->config->get('egopay_order_status_fail_id'), 'Egopay status: ' . $info->status, false);
                        $this->data['egopay_template'] = 'canceled';
                        $this->data['error_canceled'] = $this->language->get('error_canceled');
                    break;

                    default:
                        $this->data['egopay_template'] = 'process';
                        $this->data['error_process'] = $this->language->get('error_process');
                        $this->data['button_finish'] = $this->language->get('button_finish');
                        $this->data['button_finish_url'] = $this->url->link('checkout/success');
                    break;
                }

            } catch (SoapFault $fault) {
                if ($fault->faultstring === 'INVALID_ORDER') {
                    // заказ с таким номером не зарегистрирован
                    $this->model_checkout_order->update($orderInfo['order_id'], $this->config->get('egopay_order_status_fail_id'), 'Egopay status: ' . $info->status, false);
                    $this->data['egopay_template'] = 'invalid_order';
                    $this->data['error_invalid_order'] = $this->language->get('error_invalid_order');
                }
            }

            $this->egoRender();
        }
    }


    public function status_fault() {
        $this->language->load('payment/egopay');

        $this->data['egopay_template'] = 'status_fault';
        $this->data['button_try_again'] = $this->language->get('button_try_again');
        $this->data['error_status_fault'] = $this->language->get('error_status_fault');

        $this->egoRender();
    }


    function egoRender() {
        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/egopay.tpl')) {
            $this->template = $this->config->get('config_template') . '/template/payment/egopay.tpl';
        } else {
            $this->template = 'default/template/payment/egopay.tpl';
        }

        $this->data['heading_title'] = '';

        $this->data['content_bottom'] = $this->render();

        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/home.tpl')) {
            $this->template = $this->config->get('config_template') . '/template/common/home.tpl';
        } else {
            $this->template = 'default/template/common/home.tpl';
        }
    
        $this->children = array(
            'common/column_left',
            'common/column_right',
            'common/content_top',
            'common/footer',
            'common/header'
        );
                
        $this->response->setOutput($this->render());

    }


    public function cron() {
        $this->load->model('payment/egopay');
        $this->model_payment_egopay->updateOrdersStatuses();
    }

}
?>