<?php 
class ControllerPaymentEgopay extends Controller {
    private $error = array(); 

    public function index() {
        $this->language->load('payment/egopay');

        $this->document->setTitle($this->language->get('heading_title'));
        
        $this->load->model('setting/setting');
            
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('egopay', $this->request->post);
            
            $this->session->data['success'] = $this->language->get('text_success');

            $this->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
        }

        $this->data['heading_title'] = $this->language->get('heading_title');

        $this->data['text_enabled'] = $this->language->get('text_enabled');
        $this->data['text_disabled'] = $this->language->get('text_disabled');
        $this->data['text_all_zones'] = $this->language->get('text_all_zones');
        $this->data['text_yes'] = $this->language->get('text_yes');
        $this->data['text_no'] = $this->language->get('text_no');
        $this->data['text_authorization'] = $this->language->get('text_authorization');
        $this->data['text_sale'] = $this->language->get('text_sale');
        
        $this->data['shop_login'] = $this->language->get('shop_login');
        $this->data['shop_password'] = $this->language->get('shop_password');
        $this->data['shop_id'] = $this->language->get('shop_id');
        $this->data['shop_url'] = $this->language->get('shop_url');
        $this->data['entry_order_status_success'] = $this->language->get('entry_order_status_success');
        $this->data['entry_order_status_fail'] = $this->language->get('entry_order_status_fail');
        $this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
        $this->data['entry_status'] = $this->language->get('entry_status');
        $this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
        
        $this->data['button_save'] = $this->language->get('button_save');
        $this->data['button_cancel'] = $this->language->get('button_cancel');

    	if (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }
        $this->data['breadcrumbs'] = array();

       	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
        	'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
        	'separator' => false
       	);

        $this->data['breadcrumbs'][] = array(
            'text'      => $this->language->get('text_payment'),
            'href'      => $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );

        $this->data['breadcrumbs'][] = array(
            'text'      => $this->language->get('heading_title'),
            'href'      => $this->url->link('payment/egopay', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );
                
        $this->data['action'] = $this->url->link('payment/egopay', 'token=' . $this->session->data['token'], 'SSL');
        
        $this->data['cancel'] = $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL');

        if (isset($this->request->post['egopay_shop_id'])) {
            $this->data['egopay_shop_id'] = $this->request->post['egopay_shop_id'];
        } else {
            $this->data['egopay_shop_id'] = $this->config->get('egopay_shop_id');
        }
        
        if (isset($this->request->post['egopay_shop_login'])) {
            $this->data['egopay_shop_login'] = $this->request->post['egopay_shop_login'];
        } else {
            $this->data['egopay_shop_login'] = $this->config->get('egopay_shop_login');
        }
                
        if (isset($this->request->post['egopay_shop_password'])) {
            $this->data['egopay_shop_password'] = $this->request->post['egopay_shop_password'];
        } else {
            $this->data['egopay_shop_password'] = $this->config->get('egopay_shop_password');
        }
        
        if (isset($this->request->post['egopay_shop_url'])) {
            $this->data['egopay_shop_url'] = $this->request->post['egopay_shop_url'];
        } else {
            $this->data['egopay_shop_url'] = $this->config->get('egopay_shop_url');
        }
        
        if (isset($this->request->post['egopay_order_status_success_id'])) {
            $this->data['egopay_order_status_success_id'] = $this->request->post['egopay_order_status_success_id'];
        } else {
            $this->data['egopay_order_status_success_id'] = $this->config->get('egopay_order_status_success_id'); 
        }

        if (isset($this->request->post['egopay_order_status_fail_id'])) {
            $this->data['egopay_order_status_fail_id'] = $this->request->post['egopay_order_status_fail_id'];
        } else {
            $this->data['egopay_order_status_fail_id'] = $this->config->get('egopay_order_status_fail_id'); 
        } 

        $this->load->model('localisation/order_status');
        
        $this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
        
        if (isset($this->request->post['egopay_geo_zone_id'])) {
            $this->data['egopay_geo_zone_id'] = $this->request->post['egopay_geo_zone_id'];
        } else {
            $this->data['egopay_geo_zone_id'] = $this->config->get('egopay_geo_zone_id'); 
        } 
        
        $this->load->model('localisation/geo_zone');
                                        
        $this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();
        
        if (isset($this->request->post['egopay_status'])) {
            $this->data['egopay_status'] = $this->request->post['egopay_status'];
        } else {
            $this->data['egopay_status'] = $this->config->get('egopay_status');
        }
        
        if (isset($this->request->post['egopay_sort_order'])) {
            $this->data['egopay_sort_order'] = $this->request->post['egopay_sort_order'];
        } else {
            $this->data['egopay_sort_order'] = $this->config->get('egopay_sort_order');
        }

        $this->template = 'payment/egopay.tpl';
        $this->children = array(
            'common/header',
            'common/footer'
        );
                
        $this->response->setOutput($this->render());
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'payment/egopay')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        
        if (!$this->error) {
            return true;
        } else {
            return false;
        }    
    }
}
?>