<?php 
class ControllerPaymentIPS extends Controller {
    private $error = array(); 

    public function index() {
        $this->load->language('payment/ips');

        $this->document->setTitle($this->language->get('heading_title'));
        
        $this->load->model('setting/setting');
            
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('ips', $this->request->post);
            
            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
        }

        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_edit'] = $this->language->get('heading_title');

        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');
        $data['text_all_zones'] = $this->language->get('text_all_zones');
        $data['text_yes'] = $this->language->get('text_yes');
        $data['text_no'] = $this->language->get('text_no');
        $data['text_authorization'] = $this->language->get('text_authorization');
        $data['text_sale'] = $this->language->get('text_sale');
        
        $data['shop_login'] = $this->language->get('shop_login');
        $data['shop_password'] = $this->language->get('shop_password');
        $data['shop_id'] = $this->language->get('shop_id');
        $data['shop_url'] = $this->language->get('shop_url');
        $data['entry_order_status_success'] = $this->language->get('entry_order_status_success');
        $data['entry_order_status_fail'] = $this->language->get('entry_order_status_fail');
        $data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
        $data['entry_status'] = $this->language->get('entry_status');
        $data['entry_sort_order'] = $this->language->get('entry_sort_order');
        
        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

    	if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }
        $data['breadcrumbs'] = array();

       	$data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
        	'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
        	'separator' => false
       	);

        $data['breadcrumbs'][] = array(
            'text'      => $this->language->get('text_payment'),
            'href'      => $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );

        $data['breadcrumbs'][] = array(
            'text'      => $this->language->get('heading_title'),
            'href'      => $this->url->link('payment/ips', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );
                
        $data['action'] = $this->url->link('payment/ips', 'token=' . $this->session->data['token'], 'SSL');
        
        $data['cancel'] = $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL');

        if (isset($this->request->post['ips_shop_id'])) {
            $data['ips_shop_id'] = $this->request->post['ips_shop_id'];
        } else {
            $data['ips_shop_id'] = $this->config->get('ips_shop_id');
        }
        
        if (isset($this->request->post['ips_shop_login'])) {
            $data['ips_shop_login'] = $this->request->post['ips_shop_login'];
        } else {
            $data['ips_shop_login'] = $this->config->get('ips_shop_login');
        }
                
        if (isset($this->request->post['ips_shop_password'])) {
            $data['ips_shop_password'] = $this->request->post['ips_shop_password'];
        } else {
            $data['ips_shop_password'] = $this->config->get('ips_shop_password');
        }
        
        if (isset($this->request->post['ips_shop_url'])) {
            $data['ips_shop_url'] = $this->request->post['ips_shop_url'];
        } else {
            $data['ips_shop_url'] = $this->config->get('ips_shop_url');
        }
        
        if (isset($this->request->post['ips_order_status_success_id'])) {
            $data['ips_order_status_success_id'] = $this->request->post['ips_order_status_success_id'];
        } else {
            $data['ips_order_status_success_id'] = $this->config->get('ips_order_status_success_id'); 
        }

        if (isset($this->request->post['ips_order_status_fail_id'])) {
            $data['ips_order_status_fail_id'] = $this->request->post['ips_order_status_fail_id'];
        } else {
            $data['ips_order_status_fail_id'] = $this->config->get('ips_order_status_fail_id'); 
        } 

        $this->load->model('localisation/order_status');
        
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
        
        if (isset($this->request->post['ips_geo_zone_id'])) {
            $data['ips_geo_zone_id'] = $this->request->post['ips_geo_zone_id'];
        } else {
            $data['ips_geo_zone_id'] = $this->config->get('ips_geo_zone_id'); 
        } 
        
        $this->load->model('localisation/geo_zone');
                                        
        $data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();
        
        if (isset($this->request->post['ips_status'])) {
            $data['ips_status'] = $this->request->post['ips_status'];
        } else {
            $data['ips_status'] = $this->config->get('ips_status');
        }
        
        if (isset($this->request->post['ips_sort_order'])) {
            $data['ips_sort_order'] = $this->request->post['ips_sort_order'];
        } else {
            $data['ips_sort_order'] = $this->config->get('ips_sort_order');
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('payment/ips.tpl', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'payment/ips')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        
        if (!$this->error) {
            return true;
        } else {
            return false;
        }    
    }
}
?>