<?php

class Payment_egopay {

    private $shop = null;

    function __construct($shop) {
        $this->shop = $shop;

        if (!$shop->OrderID && $_GET['OrderNumber']) {
            $this->shop->LoadOrder($_GET['OrderNumber']);
        }
    }


    function create_bill($to_string = false) {
        global $SUB_FOLDER, $HTTP_ROOT_PATH, $DOMAIN_NAME;

        $form = '<form id="fegopay" action="http://' . $DOMAIN_NAME . $SUB_FOLDER . $HTTP_ROOT_PATH . 'modules/netshop/egopay.php?type=register&OrderNumber=' . $this->shop->OrderID . '" method="post">';
        if (!$to_string) {
            echo $form, '<input type=submit value="', NETCAT_MODULE_NETSHOP_PAYMENT_SUBMIT, '"></form>';
            return true;
        } else {
            return $form . '</form>';
        }
    }


    function register() {
        global $NETCAT_FOLDER, $SUB_FOLDER, $HTTP_ROOT_PATH, $DOMAIN_NAME;
        require_once($NETCAT_FOLDER . 'netcat/modules/netshop/payment/orderv2.php');

        $RUR = $this->shop->CurrencyDetails['RUR']['Currency'];
        $orderAmount = $this->shop->ConvertCurrency($this->shop->CartSum(), $this->shop->DefaultCurrencyID, $RUR);
        $orderAmount = number_format($orderAmount, 2, '.', '');

        $url = 'http://' . $DOMAIN_NAME . $SUB_FOLDER . $HTTP_ROOT_PATH . 'modules/netshop/egopay.php?OrderNumber=' . $this->shop->OrderID;

        $soapClient = $this->newSoap();
        $request = $this->prepareOrder(
            $this->shop->OrderID, 
            $orderAmount, 
            (int) $this->shop->Order['User_ID'], 
            $this->shop->Order['ContactName'], 
            $this->shop->Order['Email'], 
            $this->shop->Order['Phone'], 
            $url . '&type=success',
            $url . '&type=failed'
        );
        try {
            $info = $soapClient->register_online($request);
            header('Location: ' . $info->redirect_url . '?session=' . $info->session);
            die();
        } catch (SoapFault $fault) {
            ?>
                <h1>Ошибка</h1>
                <p>Произошла ошибка при регистрации заказа. Попробуйте обновить страницу. Если ошибка повторилась, свяжитесь со службой поддержки магазина и сообщите им код ошибки, приведённый ниже.</p>
                <p>
                    <code><?php echo $fault->faultstring ?></code>
                </p>
            <?php
        } catch (Exception $e) {
            ?>
                <h1>Ошибка</h1>
                <p>Произошла ошибка. Пожалуйста, свяжитесь со службой поддержки магазина и сообщите им код ошибки, приведённый ниже.</p>
                <p>
                    <code><?php echo $e ?></code>
                </p>
            <?php
        }
    }


    function success() {
        global $NETCAT_FOLDER;
        require_once($NETCAT_FOLDER . 'netcat/modules/netshop/payment/orderv2.php');

        $soapClient = $this->newSoap();
        $objStatus = $this->getOrderStatus($this->shop->OrderID);

        if ((int) $this->shop->Order['Status'] > 0) {
            ?>
                <h1>Ошибка</h1>
                <p>Заказ № <a href="/ishop/order_<?php echo $this->shop->OrderID ?>.html"><strong>№ <?php echo $this->shop->OrderID ?></strong></a> уже обработан.</p>
            <?php
            return;
        }

        try {
            // получаем статуса заказа от платёжной системы
            $info = $soapClient->get_status($objStatus);

            switch ($info->status) {
                case 'acknowledged':
                case 'not_acknowledged':
                case 'authorized':
                    /* помечаем статус как 3 - "оплачен" и записываем информацию о запросе */

                    q("UPDATE Message{$this->shop->order_table} SET Status='3', PaymentInfo='Статус оплаты обновлён " . date('d.m.Y H:i') . ", ответ платёжной системы: " . $info->status . "' WHERE Message_ID = {$this->shop->OrderID}");

                    ?>
                        <h1>Подтверждение платежа</h1>
                        <p>Спасибо, информация об оплате заказа <a href="/ishop/order_<?php echo $this->shop->OrderID ?>.html"><strong>№ <?php echo $this->shop->OrderID ?></strong></a> получена.</p>
                    <?php
                break;

                case 'canceled':
                case 'not_authorized':
                    /* отмечаем статус как 2 - "отклонен" */
                    q("UPDATE Message{$this->shop->order_table} SET Status='2', PaymentInfo='Статус оплаты обновлён " . date('d.m.Y H:i') . ", ответ платёжной системы: " . $info->status . "' WHERE Message_ID = {$this->shop->OrderID}");

                    ?>
                        <h1>Платёж отменён</h1>
                        <p>Оплата заказа <a href="/ishop/order_<?php echo $this->shop->OrderID ?>.html"><strong>№ <?php echo $this->shop->OrderID ?></strong></a> не прошла.</p>
                    <?php
                break;

                default:
                break;
            }

        } catch (SoapFault $fault) {
            if ($fault->faultstring === 'INVALID_ORDER') {
                // заказ с таким номером не зарегистрирован

                /* отмечаем статус как 2 - "отклонен"*/
                q("UPDATE Message{$this->shop->order_table} SET Status='2', PaymentInfo='Статус оплаты обновлён " . date('d.m.Y H:i') . ", ответ платёжной системы: " . $fault->faultstring . "' WHERE Message_ID = {$this->shop->OrderID}");

                ?>
                    <h1>Платёж отменён</h1>
                    <p>Заказ с таким номером (<a href="/ishop/order_<?php echo $this->shop->OrderID ?>.html"><strong>№ <?php echo $this->shop->OrderID ?></strong></a>) не был зарегистрирован.</p>
                <?php
            }
        } catch (Exception $e) {
            ?>
                <h1>Ошибка</h1>
                <p>Произошла ошибка. Пожалуйста, свяжитесь со службой поддержки магазина и сообщите им код ошибки, приведённый ниже.</p>
                <p>
                    <code><?php echo $e ?></code>
                </p>
            <?php
        }

    }


    function failed() {
        q("UPDATE Message{$this->shop->order_table} SET Status='2', PaymentInfo='Статус оплаты обновлён " . date('d.m.Y H:i') . ", ответ платёжной системы: Failed' WHERE Message_ID = {$this->shop->OrderID}");

        ?>
            <h1>Платёж отменён</h1>
            <p>Оплата заказа <a href="/ishop/order_<?php echo $this->shop->OrderID ?>.html"><strong>№ <?php echo $this->shop->OrderID ?></strong></a> не прошла.</p>
        <?php
    }


    public function newSoap() {
        return new orderv2(null, array(
                                'location' => $this->shop->egopay_url,
                                'uri'      => 'http://www.sirena-travel.ru',
                                'login'    => $this->shop->egopay_login,
                                'password' => $this->shop->egopay_password,
                                'trace'    => 0,
                                'features' => SOAP_SINGLE_ELEMENT_ARRAYS,
                                'connection_timeout' => 12));
    }


    public function prepareOrder($orderId, $orderAmount, $userId, $userName, $userEmail, $userPhone, $okUrl, $faultUrl) {
        $request = new register_online();
        $order = new OrderID(); 
        $order->shop_id = $this->shop->egopay_shop_id;
        $order->number = $orderId;
        $cost = new Amount();
        $cost->amount = $orderAmount;
        $cost->currency = 'RUB';
        $customer = new CustomerInfo();
        if ($userId != 0) {
            $customer->id = $userId;
        }
        $customer->name = $userName;
        $customer->email = $userEmail;
        $customer->phone = $userPhone;
        $description = new OrderInfo();
        $description->paytype = 'card';
        $language = new PostEntry();
        $language->name = 'Language';
        $language->value = 'ru';
        $returnUrlOk = new PostEntry();
        $returnUrlOk->name = 'ReturnURLOk';
        $returnUrlOk->value = $okUrl;
        $returnUrlFault = new PostEntry();
        $returnUrlFault->name = 'ReturnURLFault';
        $returnUrlFault->value = $faultUrl;
        $cardtype = new PostEntry();
        $cardtype->name = 'ChoosenCardType';
        $cardtype->value = 'VI';
        $request->order = $order;
        $request->cost = $cost;
        $request->customer = $customer;
        $request->description = $description;

        $postdata = new SoapVar(array(
                                        new SoapVar($language, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                        new SoapVar($cardtype, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                        new SoapVar($returnUrlOk, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                        new SoapVar($returnUrlFault, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                ), SOAP_ENC_OBJECT);

        $request->postdata = $postdata;

        return $request;
    }


    public function getOrderStatus($orderId) {
        $status = new get_status();
        $order = new OrderID();
        $order->shop_id = $this->shop->egopay_shop_id;
        $order->number = $orderId;
        $status->order = $order;
        return $status;
    }


    function updateStatus() {
        global $NETCAT_FOLDER;
        require_once($NETCAT_FOLDER . 'netcat/modules/netshop/payment/orderv2.php');

        $soapClient = $this->newSoap();
        $objStatus = $this->getOrderStatus($this->shop->OrderID);

        try {
            // получаем статуса заказа от платёжной системы
            $info = $soapClient->get_status($objStatus);

            switch ($info->status) {
                case 'acknowledged':
                case 'not_acknowledged':
                case 'authorized':
                    /* помечаем статус как 3 - "оплачен" и записываем информацию о запросе */
                    q("UPDATE Message{$this->shop->order_table} SET Status='3', PaymentInfo='Статус оплаты обновлён " . date('d.m.Y H:i') . ", ответ платёжной системы: " . $info->status . "' WHERE Message_ID = {$this->shop->OrderID}");
                break;

                case 'canceled':
                case 'not_authorized':
                    /* отмечаем статус как 2 - "отклонен" */
                    q("UPDATE Message{$this->shop->order_table} SET Status='2', PaymentInfo='Статус оплаты обновлён " . date('d.m.Y H:i') . ", ответ платёжной системы: " . $info->status . "' WHERE Message_ID = {$this->shop->OrderID}");
                break;
            }

            echo 'Статус заказа № ', $this->shop->OrderID, ': ', $info->status, "\r\n";

        } catch (SoapFault $fault) {
            echo 'Ошибка при проверке статуса заказа № ', $this->shop->OrderID, ': ', $fault->faultcode , '-' , $fault->faultstring, "\r\n";
            if ($fault->faultstring === 'INVALID_ORDER') {
                // заказ с таким номером не зарегистрирован

                /* отмечаем статус как 2 - "отклонен"*/
                q("UPDATE Message{$this->shop->order_table} SET Status='2', PaymentInfo='Статус оплаты обновлён " . date('d.m.Y H:i') . ", ответ платёжной системы: " . $fault->faultstring . "' WHERE Message_ID = {$this->shop->OrderID}");
            }
        } catch (Exception $e) {
            echo 'Ошибка при проверке статуса заказа № ', $this->shop->OrderID, ': PHP EXCEPTION', "\r\n";
        }

    }


}

?>