<?php
class Egopay_Egopay_RedirectController extends Mage_Core_Controller_Front_Action {

    public function indexAction() {
        $model = Mage::getModel('Egopay/Egopay');
        $maOrder = $model->getOrder();
        $maOrderData = $maOrder->getData();

        $settings = array(
                            'shop_id' => $model->getConfigData('shop_id'),
                            'shop_login' => $model->getConfigData('shop_login'),
                            'shop_pass' => $model->getConfigData('shop_pass'),
                            'shop_url' => $model->getConfigData('shop_url'),
                            'order_id' => $maOrderData['entity_id'],
                            'order_sum' => trim(round($maOrder->getGrandTotal(), 2)),
                            'user_id' => $maOrderData['customer_id'],
                            'user_name' => $maOrderData['customer_lastname'] . ' ' . $maOrderData['customer_firstname'],
                            'user_email' => $maOrderData['customer_email'],
                            'user_phone' => '',
                            'return_url' => Mage::getBaseUrl('link') . 'Egopay/redirect/success/id/' . $maOrderData['entity_id'] . '/code/' . $maOrderData['protect_code'],
                         );

        $soapClient = Mage::helper('Egopay')->newSoap($settings);
        $request = Mage::helper('Egopay')->prepareOrder($settings);
        try {
            $info = $soapClient->register_online($request);
            // всё ок, зарегистрировали, перенаправляем на платёжную систему
            $this->_redirectUrl($info->redirect_url . '?session=' . $info->session);
        } catch (SoapFault $fault) {
            Mage::getSingleton('core/session')->addError($fault->faultstring);
            $this->_redirect('Egopay/redirect/fault/');
        }

    }

    public function faultAction() {
        $this->loadLayout();
        // $block = $this->getLayout()->createBlock('Egopay/fault');
        // $this->getLayout()->getBlock('content')->append($block);
        $this->renderLayout();
    }

    public function successAction() {
        if ($this->getRequest()->getParam('status') == 'ok') {

            $orderId = (int) $this->getRequest()->getParam('id');

            $model = Mage::getModel('Egopay/Egopay');

            $maOrder = Mage::getModel('sales/order')->load($orderId);
            $maOrderData = $maOrder->getData();

            $settings = array(
                                'shop_id' => $model->getConfigData('shop_id'),
                                'shop_login' => $model->getConfigData('shop_login'),
                                'shop_pass' => $model->getConfigData('shop_pass'),
                                'shop_url' => $model->getConfigData('shop_url'),
                             );

            $soapClient = Mage::helper('Egopay')->newSoap($settings);
            $objStatus = Mage::helper('Egopay')->getOrderStatus($settings['shop_id'], $orderId);

            if (($orderId == $maOrder->getId()) && ($maOrderData['protect_code'] == $this->getRequest()->getParam('code'))) {
                try {
                    // получаем статуса заказа от платёжной системы
                    $info = $soapClient->get_status($objStatus);

                    switch ($info->status) {
                        case 'acknowledged':
                        case 'not_acknowledged':
                        case 'authorized':
                            $maOrder->setStatus($model->getConfigData('order_status_success'));
                            $maOrder->save();
                        break;

                        case 'canceled':
                        case 'not_authorized':
                            // оплата заказа не удалась
                            $maOrder->setStatus($model->getConfigData('order_status_fail'));
                            $maOrder->save();
                        break;
                    }

                } catch (SoapFault $fault) {
                    if ($fault->faultstring === 'INVALID_ORDER') {
                        // заказ с таким номером не зарегистрирован
                        $maOrder->setStatus($model->getConfigData('order_status_fail'));
                        $maOrder->save();
                    }
                }
                $this->_redirect('checkout/onepage/success', array('_secure' => true));
            } else {
                Mage::getSingleton('core/session')->addError($this->__('Wrong order id or protection code'));
                $this->_redirect('Egopay/redirect/fault/');
            }

        } else {
            Mage::getSingleton('core/session')->addError($this->__('There was an error proccesing your payment'));
            $this->_redirect('Egopay/redirect/fault/');
        }

    }

}