<?php

class Egopay_Egopay_Model_Egopay extends Mage_Payment_Model_Method_Abstract {

    protected $_code = 'Egopay';

    public function getCheckout() {
        return Mage::getSingleton('checkout/session');
    }

    public function getOrderPlaceRedirectUrl() {
        return Mage::getUrl('Egopay/redirect', array('_secure' => true));
    }

    public function getOrder() {
        $order_id = $this->getCheckout()->getLastRealOrderId();
        $order = Mage::getModel('sales/order')->loadByIncrementId($order_id);
        return $order;
    }

    public function cron() {
        $paymentTable = Mage::getSingleton('core/resource')->getTableName('sales_flat_order_payment');
        $collection = Mage::getModel('sales/order')->getCollection();
        $collection->getSelect()->join($paymentTable, $paymentTable . '.method="Egopay" AND main_table.entity_id=' . $paymentTable . '.parent_id', false, null, 'inner');
        $collection->addFieldToFilter('status', array('nin'=> array($this->getConfigData('order_status_success'), $this->getConfigData('order_status_fail'))))->addAttributeToSelect('increment_id');
        $orders = $collection->getData();

        $soapClient = Mage::helper('Egopay')->newSoap(array(
                                                            'shop_id' => $this->getConfigData('shop_id'),
                                                            'shop_login' => $this->getConfigData('shop_login'),
                                                            'shop_pass' => $this->getConfigData('shop_pass'),
                                                            'shop_url' => $this->getConfigData('shop_url')
                                                      ));

        if (sizeof($orders) > 0) {
            foreach ($orders as $o) {
                $maOrder = Mage::getModel('sales/order')->loadByIncrementId($o['increment_id']);
                $objStatus = Mage::helper('Egopay')->getOrderStatus($this->getConfigData('shop_id'), $o['increment_id']);

                try {
                    $info = $soapClient->get_status($objStatus);

                    switch ($info->status) {
                        case 'acknowledged':
                        case 'not_acknowledged':
                        case 'authorized':
                            $maOrder->setStatus($this->getConfigData('order_status_success'));
                            $maOrder->save();
                        break;

                        case 'canceled':
                        case 'not_authorized':
                            // оплата заказа не удалась
                            $maOrder->setStatus($this->getConfigData('order_status_fail'));
                            $maOrder->save();
                        break;

                    }
                    echo 'Статус заказа № ', $o['increment_id'], ': ', $info->status, "\r\n";

                } catch (SoapFault $fault) {
                    echo 'Ошибка при проверке статуса заказа № ', $o['increment_id'], ': ', $fault->faultcode , '-' , $fault->faultstring, "\r\n";
                    if ($fault->faultstring === 'INVALID_ORDER') {
                        // заказ с таким номером не зарегистрирован
                        $maOrder->setStatus($this->getConfigData('order_status_fail'));
                        $maOrder->save();
                    }
                }
            
            }

        }

    }

}
