<?
require_once('orderv2.php');

class Egopay_Egopay_Helper_Data extends Mage_Core_Helper_Abstract {

    // подготавливаем новое soap-соединение
    public function newSoap($settings) {
        return new orderv2(null, array(
                                        'location' => $settings['shop_url'],
                                        'uri'      => 'http://www.sirena-travel.ru',
                                        'login'    => $settings['shop_login'],
                                        'password' => $settings['shop_pass'],
                                        'trace'    => 0,
                                        'features' => SOAP_SINGLE_ELEMENT_ARRAYS,
                                        'connection_timeout' => 12));
    }

    // подготавливаем данные заказа для отправки
    public function prepareOrder($settings) {
        $request = new register_online();
        $order = new OrderID(); 
        $order->shop_id = $settings['shop_id'];
        $order->number = $settings['order_id'];
        $cost = new Amount();
        $cost->amount = $settings['order_sum'];
        $cost->currency = 'RUB';
        $customer = new CustomerInfo();
        if ($settings['user_id'] != 0) {
            $customer->id = $settings['user_id'];
        }
        $customer->name = $settings['user_name'];
        $customer->email = $settings['user_email'];
        $customer->phone = $settings['user_phone'];
        $description = new OrderInfo();
        $description->paytype = 'card';
        $language = new PostEntry();
        $language->name = 'Language';
        $language->value = 'ru';
        $returnUrlOk = new PostEntry();
        $returnUrlOk->name = 'ReturnURLOk';
        $returnUrlOk->value = $settings['return_url'] . '/status/ok';
        $returnUrlFault = new PostEntry();
        $returnUrlFault->name = 'ReturnURLFault';
        $returnUrlFault->value = $settings['return_url'] . '/status/fault';
        $cardtype = new PostEntry();
        $cardtype->name = 'ChoosenCardType';
        $cardtype->value = 'VI';
        $request->order = $order;
        $request->cost = $cost;
        $request->customer = $customer;
        $request->description = $description;

        $postdata = new SoapVar(array(
                                        new SoapVar($language, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                        new SoapVar($cardtype, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                        new SoapVar($returnUrlOk, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                        new SoapVar($returnUrlFault, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                ), SOAP_ENC_OBJECT);

        $request->postdata = $postdata;

        return $request;
    }

    // подготавливаем структуру для запроса статуса заказа
    public function getOrderStatus($shopId, $orderId) {
        $status = new get_status();
        $order = new OrderID();
        $order->shop_id = $shopId;
        $order->number = $orderId;
        $status->order = $order;
        return $status;
    }

}
