<?php
/**
 * @package      ITPrism Components
 * @subpackage   ITPDonate
 * @author       Todor Iliev
 * @copyright    Copyright (C) 2010 Todor Iliev <todor@itprism.com>. All rights reserved.
 * @license      http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ITPDonate is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// no direct access
defined( '_JEXEC' ) or die;

/**
 * Script file of ItpDonate component
 */
class pkg_itpDonateInstallerScript {
    
        /**
         * method to install the component
         *
         * @return void
         */
        public function install($parent) {
        }
 
        /**
         * method to uninstall the component
         *
         * @return void
         */
        public function uninstall($parent) {
        }
 
        /**
         * method to update the component
         *
         * @return void
         */
        public function update($parent) {
        }
 
        /**
         * method to run before an install/update/uninstall method
         *
         * @return void
         */
        public function preflight($type, $parent) {
        }
 
        /**
         * method to run after an install/update/uninstall method
         *
         * @return void
         */
        public function postflight($type, $parent) {
            
            if(!defined("PATH_ITPDONATE_COMPONENT_ADMINISTRATION")) {
                define("PATH_ITPDONATE_COMPONENT_ADMINISTRATION", JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . "components" . DIRECTORY_SEPARATOR ."com_itpdonate");
            }
            
            // Register Component helpers
            JLoader::register("ItpDonateInstallHelper", PATH_ITPDONATE_COMPONENT_ADMINISTRATION.DIRECTORY_SEPARATOR."helpers".DIRECTORY_SEPARATOR."install.php");
        
            $this->bootstrap    = JPath::clean( JPATH_SITE.DIRECTORY_SEPARATOR."media".DIRECTORY_SEPARATOR."com_itpdonate".DIRECTORY_SEPARATOR."css".DIRECTORY_SEPARATOR."admin".DIRECTORY_SEPARATOR."bootstrap.min.css" );
        
            $style = '<style>'.file_get_contents($this->bootstrap).'</style>';
            echo $style;
            
            if(strcmp($type, "install") == 0) {
            
                // Start table with the information
                ItpDonateInstallHelper::startTable();
                
                // Requirements
                ItpDonateInstallHelper::addRowHeading(JText::_("COM_ITPDONATE_MINIMUM_REQUIREMENTS"));
            
                // Display result about verification for GD library
                $title  = JText::_("COM_ITPDONATE_GD_LIBRARY");
                $info   = "";
                if(!extension_loaded('gd') AND function_exists('gd_info')) {
                    $result = array("type" => "important", "text" => JText::_("COM_ITPDONATE_WARNING"));
                } else {
                    $result = array("type" => "success"  , "text" => JText::_("JON"));
                }
                ItpDonateInstallHelper::addRow($title, $result, $info);
                
                // Display result about verification for cURL library
                $title  = JText::_("COM_ITPDONATE_CURL_LIBRARY");
                $info   = "";
                if( !extension_loaded('curl') ) {
                    $info   = JText::_("COM_ITPDONATE_CURL_INFO");
                    $result = array("type" => "important", "text" => JText::_("COM_ITPDONATE_WARNING"));
                } else {
                    $result = array("type" => "success"  , "text" => JText::_("JON"));
                }
                ItpDonateInstallHelper::addRow($title, $result, $info);
                
                // Display result about verification Magic Quotes
                $title  = JText::_("COM_ITPDONATE_MAGIC_QUOTES");
                $info   = "";
                if( get_magic_quotes_gpc() ) {
                    $info   = JText::_("COM_ITPDONATE_MAGIC_QUOTES_INFO");
                    $result = array("type" => "important", "text" => JText::_("JON"));
                } else {
                    $result = array("type" => "success"  , "text" => JText::_("JOFF"));
                }
                ItpDonateInstallHelper::addRow($title, $result, $info);
                
                // Display result about verification FileInfo
                $title  = JText::_("COM_ITPDONATE_FILEINFO");
                $info   = "";
                if( !function_exists('finfo_open') ) {
                    $info   = JText::_("COM_ITPDONATE_FILEINFO_INFO");
                    $result = array("type" => "important", "text" => JText::_("JOFF"));
                } else {
                    $result = array("type" => "success", "text" => JText::_("JON"));
                }
                ItpDonateInstallHelper::addRow($title, $result, $info);
                
                // End table
                ItpDonateInstallHelper::endTable();
            
                // Update alias in versino 1.3
                JLoader::register("ItpDonateVersion", PATH_ITPDONATE_COMPONENT_ADMINISTRATION.DIRECTORY_SEPARATOR."libraries".DIRECTORY_SEPARATOR."version.php");
                $version = new ItpDonateVersion();
                $currentVersion = $version->getShortVersion();
                if(strcmp("1.3", $currentVersion) == 0) {
                    ItpDonateInstallHelper::updateAliases();
                }
                
            }
            
            echo JText::sprintf("COM_ITPDONATE_MESSAGE_REVIEW_SAVE_SETTINGS", JRoute::_("index.php?option=com_itpdonate"));
            echo JText::sprintf("COM_ITPDONATE_MESSAGE_INSTALL_SIMPLE_DATA", JRoute::_("index.php?option=com_itpdonate&view=tools"));
                
        }
}
