<?php

defined('_JEXEC') or die;

jimport('joomla.application.component.model');

class EgopayPaymentModelOrderv2 extends JModel {
    
    public function __construct($config = array()) {
        require_once(dirname(__FILE__) . '/../orderv2.php');
        parent::__construct($config);
    }
    
    public static function newSoap($url, $login, $password) {
        return new orderv2(null, array(
                                        'location' => $url,
                                        'uri'      => 'http://www.sirena-travel.ru',
                                        'login'    => $login,
                                        'password' => $password,
                                        'trace'    => 0,
                                        'features' => SOAP_SINGLE_ELEMENT_ARRAYS));
    }

    // подготавливаем данные заказа для отправки
    public static function prepareOrder($shopId, $orderId, $orderAmount, $userName, $okUrl, $faultUrl) {
        $request = new register_online();
        $order = new OrderID(); 
        $order->shop_id = $shopId;
        $order->number = $orderId;
        $cost = new Amount();
        $cost->amount = $orderAmount;
        $cost->currency = 'RUB';
        $customer = new CustomerInfo();
        $customer->name = $userName;
        $description = new OrderInfo();
        $description->paytype = 'card';
        $language = new PostEntry();
        $language->name = 'Language';
        $language->value = 'ru';
        $returnUrlOk = new PostEntry();
        $returnUrlOk->name = 'ReturnURLOk';
        $returnUrlOk->value = $okUrl;
        $returnUrlFault = new PostEntry();
        $returnUrlFault->name = 'ReturnURLFault';
        $returnUrlFault->value = $faultUrl;
        $cardtype = new PostEntry();
        $cardtype->name = 'ChoosenCardType';
        $cardtype->value = 'VI';
        $request->order = $order;
        $request->cost = $cost;
        $request->customer = $customer;
        $request->description = $description;

        $postdata = new SoapVar(array(
                                        new SoapVar($language, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                        new SoapVar($cardtype, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                        new SoapVar($returnUrlOk, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                        new SoapVar($returnUrlFault, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                ), SOAP_ENC_OBJECT);

        $request->postdata = $postdata;

        return $request;
    }

    public static function getOrderStatus($shopId, $orderId) {
        $status = new get_status();
        $order = new OrderID();
        $order->shop_id = $shopId;
        $order->number = $orderId;
        $status->order = $order;
        return $status;
    }

}