<?php

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modellist');

class EgopayPaymentModelEgopayPayment extends JModelList {

	private $tableName = '#__egopay_standalone_pays';

	protected function getListQuery() {
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select('id, account_number, time, amount, status');
		$query->from($this->tableName);
		return $query;
	}

	public function add($accountNumber, $amount) {
		$data = new stdClass();
		$data->id = null;
		$data->account_number = $accountNumber;
		$data->time = time();
		$data->amount = $amount;
		$data->status = 'Registered';

		$db = $this->getDbo();
		if (!($db->insertObject($this->tableName, $data))) {
			return false;
		}
		
		return $db->insertId();
	}

	public function getByIdAndCode($orderId, $code) {
		$db = $this->getDbo();
		$db->setQuery('SELECT * FROM `' . $this->tableName . '` WHERE `id` = "' . $orderId . '" AND MD5(CONCAT(`id`, `account_number`)) = "' . $code . '" AND `status` NOT IN("Canceled", "Payed")');

		if (!($order = $db->loadAssoc())) {
			return false;
		}
		return $order;
	}

	public function updateStatus($orderId, $status) {
		$data = new stdClass();
		$data->id = $orderId;
		$data->status = $status;
 
 		$db = $this->getDbo();
		if (!($db->updateObject($this->tableName, $data, 'id'))) {
			return false;
		}
		
		return true;
	}

	public function cron() {
		jimport('joomla.application.component.helper');
		$url = JComponentHelper::getParams('com_egopaypayment')->get('url');
		$login = JComponentHelper::getParams('com_egopaypayment')->get('login');
		$password = JComponentHelper::getParams('com_egopaypayment')->get('pass');
		$shopId = JComponentHelper::getParams('com_egopaypayment')->get('shop_id');

		jimport('joomla.application.component.model');
		$model = JModel::getInstance('Orderv2', 'EgopayPaymentModel', array());
		$soapClient = $model::newSoap($url, $login, $password);

        $db = $this->getDbo();
		$db->setQuery('SELECT * FROM `' . $this->tableName . '` WHERE `status` IN ("Registered", "Processed")');

        if ($orders = $db->loadAssocList()) {
            if (sizeof($orders) > 0) {

            	foreach ($orders as $o) {
					$orderNumber = sprintf('1%08d', $o['id']);

					try {
		 				$objStatus = $model::getOrderStatus($shopId, $orderNumber);
						$info = $soapClient->get_status($objStatus);

						switch ($info->status) {
							case 'acknowledged':
							case 'not_acknowledged':
							case 'authorized':
								$this->updateStatus($o['id'], 'Payed');
							break;

							case 'canceled':
							case 'not_authorized':
								$this->updateStatus($o['id'], 'Canceled');
							break;
						}

						echo 'Статус заказа № ', $orderNumber, ': ', $info->status, "\r\n";

					} catch (SoapFault $fault) {
						echo 'Ошибка при проверке статуса заказа № ', $orderNumber, ': ', $fault->faultcode , '-' , $fault->faultstring, "\r\n";
						if ($fault->faultstring === 'INVALID_ORDER') {
							$this->updateStatus($o['id'], 'Canceled');
						}
					} catch (Exception $e) {
						echo 'Ошибка при проверке статуса заказа № ', $orderNumber, ': PHP EXCEPTION', "\r\n";
					}
				}
            }
        }
	}

}