<?php

defined('_JEXEC') or die('Restricted access');
 
jimport('joomla.application.component.controller');
jimport('joomla.application.component.model');
jimport('joomla.application.component.helper');

class EgopayPaymentController extends JController {

	function display($cachable = false, $urlparams = false) {
		$input = JFactory::getApplication()->input;
		$input->set('view', $input->getCmd('view', 'register'));

		parent::display($cachable);
	}

	function register($cachable = false, $urlparams = false) {
		$accountNumber = JRequest::getString('account_number', false);
		$amount = JRequest::getString('amount', false);

		if (!$accountNumber || !$amount) {
			$view = $this->getView('register', 'html');
			$view->assign('error', JText::_('COM_EGOPAYPAYMENT_ERROR_EMPTY'));
			$view->assign('account_number', htmlspecialchars($accountNumber));
			$view->assign('amount', htmlspecialchars($amount));
			$view->display();
			return;
		}

		$amount = number_format(str_replace(' ', '', str_replace(',', '.', $amount)), 2, '.', '');
		$modelOrder = JModel::getInstance('EgopayPayment', 'EgopayPaymentModel', array());
		if ($orderId = $modelOrder->add($accountNumber, $amount)) {
			$orderNumber = $accountNumber . '-' . sprintf('1%08d', $orderId);

			$url = JComponentHelper::getParams('com_egopaypayment')->get('url');
			$login = JComponentHelper::getParams('com_egopaypayment')->get('login');
			$password = JComponentHelper::getParams('com_egopaypayment')->get('pass');
			$shopId = JComponentHelper::getParams('com_egopaypayment')->get('shop_id');

			$code = md5($orderId . $accountNumber);

			$uri = JURI::getInstance();
			$uri->setVar('task', 'success');
			$uri->setVar('order', $orderNumber);
			$uri->setVar('code', $code);
			$urlOk = $uri->toString();

			$uri->setVar('task', 'fault');
			$urlFault = $uri->toString();

			$model = JModel::getInstance('Orderv2', 'EgopayPaymentModel', array());
			try {
				$soapClient = $model::newSoap($url, $login, $password);
				$request = $model::prepareOrder($shopId, $orderNumber, $amount, $accountNumber, $urlOk, $urlFault);

				$info = $soapClient->register_online($request);
				$this->setRedirect($info->redirect_url . '?session=' . $info->session);
			} catch (SoapFault $e) {
				$view = $this->getView('error', 'html');
				$view->assign('error', JText::_('COM_EGOPAYPAYMENT_ERROR_REGISTER'));
				$view->assign('code', $e->faultstring);
				$view->display();
			} catch (Exception $e) {
				$view = $this->getView('error', 'html');
				$view->assign('error', JText::_('COM_EGOPAYPAYMENT_ERROR_REGISTER'));
				$view->assign('code', $e->__toString());
				$view->display();
			}
		} else {
			$view = $this->getView('error', 'html');
			$view->assign('error', JText::_('COM_EGOPAYPAYMENT_ERROR_REGISTER'));
			$view->assign('code', JText::_('COM_EGOPAYPAYMENT_ERROR_INSERT'));
			$view->display();
		}

	}


	function success($cachable = false, $urlparams = false) {
		$orderNumber = JRequest::getString('order', '');
		$o = explode('-', $orderNumber);
		$orderId = (int) $o[ sizeof($o) - 1 ] - 100000000;
		$code = JRequest::getString('code', false);

		$modelOrder = JModel::getInstance('EgopayPayment', 'EgopayPaymentModel', array());
		if ($order = $modelOrder->getByIdAndCode((int) $orderId, htmlspecialchars($code))) {

			$url = JComponentHelper::getParams('com_egopaypayment')->get('url');
			$login = JComponentHelper::getParams('com_egopaypayment')->get('login');
			$password = JComponentHelper::getParams('com_egopaypayment')->get('pass');
			$shopId = JComponentHelper::getParams('com_egopaypayment')->get('shop_id');

			$model = JModel::getInstance('Orderv2', 'EgopayPaymentModel', array());
			try {
				$soapClient = $model::newSoap($url, $login, $password);
 				$objStatus = $model::getOrderStatus($shopId, $orderNumber);

				$info = $soapClient->get_status($objStatus);
				switch ($info->status) {
					case 'acknowledged':
					case 'not_acknowledged':
					case 'authorized':
						$modelOrder->updateStatus($orderId, 'Payed');
						$view = $this->getView('success', 'html');
						$view->assign('order_number', $orderNumber);
						$view->display();
					break;

					case 'canceled':
					case 'not_authorized':
						$modelOrder->updateStatus($orderId, 'Canceled');
						$view = $this->getView('fault', 'html');
						$view->assign('order_number', $orderNumber);
						$view->display();
					break;

					default:
						$modelOrder->updateStatus($orderId, 'Proccessed');
						$view = $this->getView('process', 'html');
						$view->assign('order_number', $orderNumber);
						$view->assign('url', JURI::getInstance()->toString());
						$view->display();
					break;
				}

			} catch (SoapFault $e) {
				if ($e->faultstring === 'INVALID_ORDER') {
					$modelOrder->updateStatus($orderId, 'Canceled');
					$view = $this->getView('fault', 'html');
					$view->assign('order_number', $orderNumber);
					$view->assign('reason', JText::_('COM_EGOPAYPAYMENT_INVALID_ORDER'));
					$view->display();
				} else {
					$view = $this->getView('error', 'html');
					$view->assign('error', JText::_('COM_EGOPAYPAYMENT_ERROR_COMMON'));
					$view->assign('code', $e->faultstring);
					$view->assign('order_number', $orderNumber);
					$view->display();
				}
			} catch (Exception $e) {
				$view = $this->getView('error', 'html');
				$view->assign('error', JText::_('COM_EGOPAYPAYMENT_ERROR_COMMON'));
				$view->assign('code', $e->__toString());
				$view->assign('order_number', $orderNumber);
				$view->display();
			}

		} else {
			$view = $this->getView('error', 'html');
			$view->assign('error', JText::_('COM_EGOPAYPAYMENT_ERROR_COMMON'));
			$view->assign('code', JText::_('COM_EGOPAYPAYMENT_WRONG_CODE'));
			$view->assign('order_number', $orderNumber);
			$view->display();
		}

	}

	function fault($cachable = false, $urlparams = false) {
		$orderNumber = JRequest::getString('order', '');
		$o = explode('-', $orderNumber);
		$orderId = (int) $o[ sizeof($o) - 1 ] - 100000000;
		$code = JRequest::getString('code', false);

		$modelOrder = JModel::getInstance('EgopayPayment', 'EgopayPaymentModel', array());
		if ($order = $modelOrder->getByIdAndCode((int) $orderId, htmlspecialchars($code))) {

			$modelOrder->updateStatus($orderId, 'Canceled');
			$view = $this->getView('fault', 'html');
			$view->assign('order_number', $orderNumber);
			$view->display();

		} else {
			$view = $this->getView('error', 'html');
			$view->assign('error', JText::_('COM_EGOPAYPAYMENT_ERROR_COMMON'));
			$view->assign('code', JText::_('COM_EGOPAYPAYMENT_WRONG_CODE'));
			$view->assign('order_number', $orderNumber);
			$view->display();
		}

	}
}