<?php

if (!defined('DIAFAN')) {
    include dirname(dirname(dirname(dirname(dirname(__FILE__))))) . '/includes/404.php';
}

class Cart_payment_egopay_model {

    public $params;

    public function __construct() {
        $this->params = unserialize(DB::query_result("SELECT params FROM {shop_payment} WHERE payment = 'egopay'"));
    }

    public function getOrderData($id) {
        $query = DB::query("SELECT id, user_id, status, status_id, summ, payment_id, code FROM {shop_order} WHERE id = %d", $id);
        $order = DB::fetch_array($query);

        $order['amount'] = number_format($order['summ'], 2, '.', '');

        $query = DB::query("SELECT `value`, param_id FROM {shop_order_param_element} where element_id = %d", $id);
        while ($row = DB::fetch_array($query)) {
            switch ($row['param_id']) {
                case $this->params['field_name']:
                    $order['name'] = $row['value'];
                break;
                case $this->params['field_email']:
                    $order['email'] = $row['value'];
                break;
                case $this->params['field_phone']:
                    $order['phone'] = $row['value'];
                break;
            }
        }

        return $order;
    }

    public function get($params) {
        return array(
            'amount' => number_format($params['summ'], 2, '.', ''),
            'order_id' => $params['order_id'],
            'shop_id' => $params['shop_id'],
            'shop_url' => $params['shop_url'],
            'shop_login' => $params['shop_login'],
            'shop_pass' => $params['shop_pass'],
        );
    }

    public function cancelOrder($orderId) {
        $statusId = DB::query_result("SELECT id FROM {shop_order_status} WHERE status = '2' LIMIT 1");
        DB::query("UPDATE {shop_order} SET status = '2', status_id = %d WHERE id = %d", $statusId, $orderId);
    }

    public function newSoap() {
        return new orderv2(null, array(
                                'location' => $this->params['shop_url'],
                                'uri'      => 'http://www.sirena-travel.ru',
                                'login'    => $this->params['shop_login'],
                                'password' => $this->params['shop_pass'],
                                'trace'    => 0,
                                'features' => SOAP_SINGLE_ELEMENT_ARRAYS,
                                'connection_timeout' => 12));
    }

    public function prepareOrder($orderId, $okUrl, $faultUrl) {
        $orderData = $this->getOrderData($orderId);

        $request = new register_online();
        $order = new OrderID(); 
        $order->shop_id = $this->params['shop_id'];
        $order->number = $orderId;
        $cost = new Amount();
        $cost->amount = $orderData['amount'];
        $cost->currency = 'RUB';
        $customer = new CustomerInfo();
        $customer->id = $orderData['user_id'];
        $customer->name = $orderData['name'];
        $customer->email = $orderData['email'];
        $customer->phone = $orderData['phone'];
        $description = new OrderInfo();
        $description->paytype = 'card';
        $language = new PostEntry();
        $language->name = 'Language';
        $language->value = 'ru';
        $returnUrlOk = new PostEntry();
        $returnUrlOk->name = 'ReturnURLOk';
        $returnUrlOk->value = $okUrl;
        $returnUrlFault = new PostEntry();
        $returnUrlFault->name = 'ReturnURLFault';
        $returnUrlFault->value = $faultUrl;
        $cardtype = new PostEntry();
        $cardtype->name = 'ChoosenCardType';
        $cardtype->value = 'VI';
        $request->order = $order;
        $request->cost = $cost;
        $request->customer = $customer;
        $request->description = $description;

        $postdata = new SoapVar(array(
                                        new SoapVar($language, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                        new SoapVar($cardtype, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                        new SoapVar($returnUrlOk, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                        new SoapVar($returnUrlFault, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
                                ), SOAP_ENC_OBJECT);

        $request->postdata = $postdata;

        return $request;
    }


    public function getOrderStatus($orderId) {
        $status = new get_status();
        $order = new OrderID();
        $order->shop_id = $this->params['shop_id'];
        $order->number = $orderId;
        $status->order = $order;
        return $status;
    }

    public function updateOrderStatuses($diafan) {
        $paymentId = DB::query_result("SELECT id FROM {shop_payment} WHERE payment = 'egopay'");

        $soapClient = $this->newSoap();
        $shop = new Shop_inc_order($diafan);

        $query = DB::query("SELECT id FROM {shop_order} WHERE payment_id = %d AND status = '0'", $paymentId);
        while ($row = DB::fetch_array($query)) {
            $orderId = $row['id'];
        
            $status = $this->getOrderStatus($orderId);
            try {
                $info = $soapClient->get_status($status);
                switch ($info->status) {
                    case 'acknowledged':
                    case 'not_acknowledged':
                    case 'authorized':
                        $shop->pay($orderId);
                    break;

                    case 'canceled':
                    case 'not_authorized':
                        $this->cancelOrder($orderId);
                    break;
                }

                echo 'Статус заказа № ', $orderId, ': ', $info->status, "\r\n";

            } catch (SoapFault $fault) {
                echo 'Ошибка при проверке статуса заказа № ', $orderId, ': ', $fault->faultcode , '-' , $fault->faultstring, "\r\n";
                
                if ($fault->faultstring === 'INVALID_ORDER') {
                    $this->cancelOrder($orderId);
                }

            } catch (Exception $e) {
                echo 'Ошибка при проверке статуса заказа № ', $orderId, ': PHP EXCEPTION', "\r\n";
            }
        }
    }

}