<?php

if (!defined('DIAFAN')) {
    include dirname(dirname(dirname(dirname(dirname(__FILE__))))) . '/includes/404.php';
}

class Cart_payment_egopay_admin {

    public $config;
    private $fields;
    private $params;

    public function __construct() {
        $this->config = array(
            'name' => 'Оплата банковскими картами (Egopay)',
            'params' => array(
                'shop_id' => 'Номер магазина (Shop ID)',
                'shop_login' => 'Логин',
                'shop_pass' => 'Пароль',
                'shop_url' => 'Адрес шлюза',
                'field_name' => array(
                    'type' => 'function',
                    'name' => 'Поле с ФИО покупателя',
                ),
                'field_email' => array(
                    'type' => 'function',
                    'name' => 'Поле с E-mail покупателя',
                ),
                'field_phone' => array(
                    'type' => 'function',
                    'name' => 'Поле с номером телефона покупателя',
                ),
            )
        );

        $this->fields = $this->getFields();
        $this->params = unserialize(DB::query_result("SELECT params FROM {shop_payment} WHERE payment = 'egopay'"));
    }

    private function getFields() {
        $fields = array();
        $query = DB::query("SELECT name1, id FROM {shop_order_param}");
        while ($row = DB::fetch_array($query)) {
            $fields[] = $row;
        }
        return $fields;
    }

    private function getOption($key, $title) {
        ?>
        <tr valign="top" id="cat_id">
            <td class="td_first"><?php echo $title?></td>
            <td>
                <select name="<?php echo $key ?>">
                <?php foreach ($this->fields as $field): ?>
                    <option value="<?php echo $field['id'] ?>" <?php if ($this->params[$key] == $field['id']) :?>selected="selected"<?php endif ?>><?php echo $field['name1'] ?></option>
                <?php endforeach ?>
                </select>
            </td>
        </tr>
        <?
    }

    public function edit_variable_field_name() {
        $this->getOption('field_name', $this->config['params']['field_name']['name']);
    }

    public function edit_variable_field_email() {
        $this->getOption('field_email', $this->config['params']['field_email']['name']);
    }

    public function edit_variable_field_phone() {
        $this->getOption('field_phone', $this->config['params']['field_phone']['name']);
    }

}