<?php

if (!defined('DIAFAN')) {
    include dirname(dirname(dirname(dirname(dirname(__FILE__))))) . '/includes/404.php';
}

class Cart_payment_egopay_controller {

    protected $model;
    protected $templatePath;

    public function __construct($method) {
        require_once(ABSOLUTE_PATH . 'modules/cart/payment/' . $method . '/api/orderv2.php');
        require_once(ABSOLUTE_PATH . 'modules/cart/payment/' . $method . '/cart.payment.' . $method . '.model.php');

        $this->model = new Cart_payment_egopay_model();
        $this->templatePath = ABSOLUTE_PATH . 'modules/cart/payment/' . $method . '/views/';
    }

    protected function fetch($template, $vars) {
        ob_start();
        try {
            extract($vars);
            include($this->templatePath . $template . '.php');
            $output = ob_get_contents();
        } catch (Exception $e) {
            $output = false;
        }
        ob_end_clean();
        return $output;
    }

    public function registerOrder($orderId) {
        $soapClient = $this->model->newSoap();
        $orderData = $this->model->getOrderData($orderId);

        $request = $this->model->prepareOrder(
            $orderId, 
            BASE_PATH . 'cart/payment/egopay/success/' . $orderId . '/' . $orderData['code'],
            BASE_PATH . 'cart/payment/egopay/fail/' . $orderId . '/' . $orderData['code']
        );
        try {
            $info = $soapClient->register_online($request);
            return $this->fetch('register', array('url' => $info->redirect_url . '?session=' . $info->session));
        } catch (SoapFault $fault) {
            return $this->fetch('error', array('code' => $fault->faultstring));
        } catch (Exception $e) {
            return $this->fetch('error', array('code' => $e->__toString()));
        }
    }

    public function fail($orderId, $secureCode) {
        $orderData = $this->model->getOrderData($orderId);

        if ($secureCode === $orderData['code']) {
            $this->model->cancelOrder($orderId);
        }
    }

    public function success($orderId, $secureCode, $diafan) {
        $orderData = $this->model->getOrderData($orderId);

        if ($secureCode !== $orderData['code']) {
            return false;
        }

        $soapClient = $this->model->newSoap();
        $status = $this->model->getOrderStatus($orderId);

        try {
            $info = $soapClient->get_status($status);

            switch ($info->status) {
                case 'acknowledged':
                case 'not_acknowledged':
                case 'authorized':
                    $diafan->_shop->order_pay($orderId);
                    return false;
                break;

                case 'canceled':
                case 'not_authorized':
                    $this->model->cancelOrder($orderId);
                    return false;
                break;

                default:
                    return true;
                break;
            }

        } catch (SoapFault $fault) {
            if ($fault->faultstring === 'INVALID_ORDER') {
                $this->model->cancelOrder($orderId);
            }
            return false;
        } catch (Exception $e) {
            return false;
        }
    }

    public function cron($diafan) {
        $this->model->updateOrderStatuses($diafan);
    }

}