<?php

DEFINE('AREA', 'C');
DEFINE('AREA_NAME', 'customer');

require('../init.php');

$installed = false;
$errors = array();

function copyDir($src, $dst) {
	$dir = opendir($src);
	mkdir($dst, 0755);

	if (is_resource($dir)) {
		while (false !== ($file = readdir($dir))) {
			if (($file != '.') && ( $file != '..')) {
				if (is_dir($src . '/' . $file)) {
					copyDir($src . '/' . $file, $dst . '/' . $file);
				} else {
					if (file_exists($dst . '/' . $file)) {
						unlink($dst . '/' . $file);
					}
					copy($src . '/' . $file, $dst . '/' . $file);
				}
			}
		}
		closedir($dir);
		return true;
	} else {
		return false;
	}

}

if (!empty($_POST['install']) && !$installed) {

	if (db_get_field("SELECT COUNT(*) FROM ?:payment_processors WHERE processor_script = 'egopay.php'") != 1) {
		$sql = "INSERT INTO ?:payment_processors 
					(processor, processor_script, processor_template, admin_template, callback, type) 
				VALUES 
					('EgoPay', 'egopay.php', 'views/orders/components/payments/cc_outside.tpl', 'egopay.tpl', 'N', 'P')
				;";

		db_query($sql);
	}
	
	if (!copy('./files/egopay.php', '../app/payments/egopay.php')) {
		$errors[] = 'Cannot copy egopay.php into payments directory.';
	}
	if (!copyDir('./files/egopay_files', '../app/payments/egopay_files')) {
		$errors[] = 'Cannot copy egopay_files into payments directory.';
	}
	if (!copy('./files/egopay.tpl', '../design/backend/templates/views/payments/components/cc_processors/egopay.tpl')) {
		$errors[] = 'Cannot copy egopay.tpl into your admin directory.';
	}

	$sql = "REPLACE INTO ?:language_values
			(lang_code, name, value, original_value)
			VALUES
			('ru', 'egopay_shop_id', 'Номер магазина (Shop ID)', 'Shop ID'),
			('ru', 'egopay_login', 'Логин', 'Login'),
			('ru', 'egopay_password', 'Пароль', 'Password'),
			('ru', 'egopay_url', 'Адрес шлюза', 'Gateway URL'),
			('ru', 'egopay_interface_language', 'Язык интерфейса', 'Interface language'),
			('ru', 'egopay_russian', 'Русский', 'Russian'),
			('ru', 'egopay_english', 'Английский', 'English'),
			('ru', 'egopay_german', 'Немецкий', 'German'),
			('ru', 'egopay_chinese', 'Китайский', 'Chinese'),
			('ru', 'egopay_register_ok', 'В скором времени будет осуществлён переход на сайт платёжной системы. Если по какой-либо причине это не произошло, Вы можете перейти <a href=\"[[url]]\">вручную</a>.', 'You will be redirected shortly. If not you can do it <a href=\"[[url]]\">manually</a>.'),
			('ru', 'egopay_error_during_pay', 'В процессе оплаты возникла ошибка: [[error_code]] [[error_string]]', 'Error occured: [[error_code]] [[error_string]]'),
			('ru', 'egopay_try_again', 'Вы можете попробовать <a href=\"[[return_url]]\">оплатить снова</a>. В случае, если ошибка повторится, обратитесь к службе поддержки магазина.', 'You can try to <a href=\"[[return_url]]\">pay again</a>. If the error repeats contact the shop support service.'),
			('ru', 'egopay_order_status', 'Заказ принят в обработку (текущий статус: [[order_status]]), вы можете дождаться результата проверки платежа или <a href=\"[[return_url]]\">закончить оформление заказа</a>, не дожидаяcь изменения статуса.', 'Заказ принят в обработку (текущий статус: [[order_status]]), вы можете дождаться результата проверки платежа или <a href=\"[[return_url]]\">закончить оформление заказа</a>, не дожидаяcь изменения статуса.'),
			('ru', 'egopay_status_unknown', 'неизвестная ошибка', 'unknown error'),
			('ru', 'egopay_status_invalid', 'заказ с таким номером не зарегистрирован', 'invalid order number'),
			('ru', 'egopay_status_acknowledged', 'успешная оплата, оформление успешно завершено', 'successful payment'),
			('ru', 'egopay_status_not_authorized', 'оплата заказа не удалась', 'payment canceled'),
			('ru', 'egopay_status_registered', 'заказ зарегистрирован и ожидает оплаты', 'payment registered'),
			('ru', 'egopay_status_in_progress', 'начата обработка платежа', 'processing of the payment has begun'),
			('ru', 'egopay_status_authorized', 'успешная оплата, идёт оформление товара/услуги', 'successful payment'),
			('ru', 'egopay_status_failed', 'сбой в обработке заказа', 'failure in the payment processing'),
			('ru', 'egopay_status_not_acknowledged', 'успешная оплата. оформление не выполнено', 'successful payment')
			;";

	db_query($sql);

	$installed = true;
}

?>

<html>
<head>
	<title>CS-Cart EgoPay Install</title>
</head>
<body>
	<div style="text-align:center; margin-top: 15%">
		<h1>CS-Cart EgoPay Install</h1>
		<?php if ($installed): ?>
			<?php if (sizeof($errors) > 0):?>
				<h3>There was an errors during install:</h3>
				<ul>
					<?php foreach($errors as $e): ?>
						<li><?php echo $e ?></li>
					<?php endforeach ?>
				</ul>
			<?php else: ?>
				<h3>EgoPay payment module successfully installed. Now you can remove this directory.</h3>
			<?php endif ?>
		<?php else: ?>		
			<form action="index.php" method="post">
				<input type="submit" name="install" value="Install" />
			</form>
		<?php endif; ?>
	</div>
</body>
</html>