<?php

if (empty($argv[1]) || ($argv[1] !== '--cron')) {
	die();
}


define('AREA', 'C');

use Tygh\Bootstrap;
use Tygh\Debugger;
use Tygh\Exceptions\DatabaseException;
use Tygh\Registry;


// Register autoloader
$this_dir = dirname(__FILE__) . '/../../..';
$classLoader = require($this_dir . '/app/lib/vendor/autoload.php');
$classLoader->add('Tygh', $this_dir . '/app');

// Prepare environment and process request vars
list($_REQUEST, $_SERVER) = Bootstrap::initEnv($_GET, $_POST, $_SERVER, $this_dir);

// Get config data
$config = require(DIR_ROOT . '/config.php');

Debugger::init();

// Start debugger log
Debugger::checkpoint('Before init');

// Callback: verifies if https works
if (isset($_REQUEST['check_https'])) {
    die(defined('HTTPS') ? 'OK' : '');
}

// Check if software is installed
if ($config['db_host'] == '%DB_HOST%') {
    $product_name = (PRODUCT_EDITION == 'ULTIMATE' ? PRODUCT_NAME : 'Multi-Vendor');
    die($product_name . ' is <b>not installed</b>. Please click here to start the installation process: <a href="install/">[install]</a>');
}

// Load core functions
$fn_list = array(
    'fn.database.php',
    'fn.users.php',
    'fn.catalog.php',
    'fn.cms.php',
    'fn.cart.php',
    'fn.locations.php',
    'fn.common.php',
    'fn.fs.php',
    'fn.images.php',
    'fn.init.php',
    'fn.control.php',
    'fn.search.php',
    'fn.promotions.php',
    'fn.log.php',
    'fn.companies.php',
    'fn.addons.php'
);

$fn_list[] = 'fn.' . strtolower(PRODUCT_EDITION) . '.php';

foreach ($fn_list as $file) {
    require($config['dir']['functions'] . $file);
}

Registry::set('class_loader', $classLoader);
Registry::set('config', $config);
unset($config);

// Connect to database
if (!db_initiate(Registry::get('config.db_host'), Registry::get('config.db_user'), Registry::get('config.db_password'), Registry::get('config.db_name'))) {
    throw new DatabaseException('Cannot connect to the database server');
}

register_shutdown_function(array('\\Tygh\\Registry', 'save'));

// define lifetime for the cache data
date_default_timezone_set('UTC'); // setting temporary timezone to avoid php warnings

if (defined('API')) {
    fn_init_stack(
        array('fn_init_api')
    );
}

fn_init_stack(
    array('fn_init_storage'),
    array('fn_init_ua')
);

fn_init_stack(
    array(array('\\Tygh\\Session', 'init'), &$_REQUEST),
    array('fn_init_ajax'),
    array('fn_init_company_id', &$_REQUEST),
    array('fn_check_cache', $_REQUEST),
    array('fn_init_settings'),
    array('fn_init_addons'),
    array('fn_get_route', &$_REQUEST),
    array('fn_simple_ultimate', &$_REQUEST)
);

if (!fn_allowed_for('ULTIMATE:FREE')) {
    fn_init_stack(array('fn_init_localization', &$_REQUEST));
}

fn_init_stack(array('fn_init_language', &$_REQUEST),
    array('fn_init_currency', &$_REQUEST),
    array('fn_init_company_data', $_REQUEST),
    array('fn_init_full_path', $_REQUEST),
    array('fn_init_layout', &$_REQUEST),
    array('fn_init_user'),
    array('fn_init_templater')
);

try {
	fn_init($_REQUEST);
} catch (Tygh\Exceptions\AException $e) {
	$e->output();
}

require_once(Registry::get('config.dir.root') . '/app/payments/egopay_files/orderv2.php');
require_once(Registry::get('config.dir.root') . '/app/payments/egopay_files/egopay.class.php');

// запрашиваем статусы заказов нашей платёжной системы

$processor = fn_get_processor_data_by_name('egopay.php');

// берём список активных платёжных систем и пытаемся найти egopay
foreach (fn_get_payment_by_processor($processor['processor_id']) as $pid => $p) {
	$paymentId = $pid;
	$processor_data = fn_get_processor_data($pid);
}

if (empty($processor_data)) {
	die('Не найден метод оплаты EgoPay');
}

// получаем заказы
$orders = fn_get_orders(array('payment_id' => $paymentId, 'status' => 'O'), 9999);

if (sizeof($orders[0]) > 0) {
	$soapClient = EgoPay::newSoap(array(
										'shop_id' => $processor_data['processor_params']['shop_id'],
										'shop_url' => $processor_data['processor_params']['url'],
										'shop_login' => $processor_data['processor_params']['login'],
										'shop_pass' => $processor_data['processor_params']['password'],
	));

	for ($i = 0, $l = sizeof($orders[0]); $i < $l; $i++) {
		$status = EgoPay::getOrderStatus($processor_data['processor_params']['shop_id'], $orders[0][$i]['order_id']);
		$arFields = '';
		try {
			$info = $soapClient->get_status($status);
			if (!empty($info->error->category) && ($info->error->category != 'system') && ($info->error->code != 'ok')) {
				echo 'Ошибка для заказа № ', $orders[0][$i]['order_id'], ': ', $info->error->category, '>', $info->error->code, "\r\n";
			} else {
				if ($info->status === 'acknowledged') {
					// заказ успешно оплачен
					fn_change_order_status($orders[0][$i]['order_id'], 'P', $orders[0][$i]['status'], false);
				}
				if ($info->status === 'not_authorized') {
					// оплата заказа не удалась
					fn_change_order_status($orders[0][$i]['order_id'], 'F', $orders[0][$i]['status'], false);
				}
				echo 'Статус заказа № ', $orders[0][$i]['order_id'], ': ', $info->status, "\r\n";
			}
		} catch (SoapFault $fault) {
			echo 'Ошибка при проверке статуса заказа № ', $orders[0][$i]['order_id'], ': ', $fault->faultcode , '-' , $fault->faultstring, "\r\n";
			if ($fault->faultstring === 'INVALID_ORDER') {
				// заказ с таким номером не зарегистрирован
				fn_change_order_status($orders[0][$i]['order_id'], 'F', $orders[0][$i]['status'], false);
			}
		}
	}

}