<?php

DEFINE('AREA', 'C');
DEFINE('AREA_NAME', 'customer');
require('../prepare.php');
require('../init.php');

$installed = false;
$errors = array();

function copyDir($src, $dst) {
	$dir = opendir($src);
	mkdir($dst, 0755);

	if (is_resource($dir)) {
		while (false !== ($file = readdir($dir))) {
			if (($file != '.') && ( $file != '..')) {
				if (is_dir($src . '/' . $file)) {
					copyDir($src . '/' . $file, $dst . '/' . $file);
				} else {
					if (file_exists($dst . '/' . $file)) {
						unlink($dst . '/' . $file);
					}
					copy($src . '/' . $file, $dst . '/' . $file);
				}
			}
		}
		closedir($dir);
		return true;
	} else {
		return false;
	}

}

if (!empty($_POST['install']) && !$installed) {

	if (db_get_field("SELECT COUNT(*) FROM ?:payment_processors WHERE processor_script = 'egopay.php'") != 1) {
		$sql = "INSERT INTO ?:payment_processors 
					(processor, processor_script, processor_template, admin_template, callback) 
				VALUES 
					('EgoPay', 'egopay.php', 'cc_outside.tpl', 'egopay.tpl', 'N')
				;";

		db_query($sql);
	}
	
	if (!copy('./files/egopay.php', '../payments/egopay.php')) {
		$errors[] = 'Cannot copy egopay.php into payments directory.';
	}
	if (!copyDir('./files/egopay_files', '../payments/egopay_files')) {
		$errors[] = 'Cannot copy egopay_files into payments directory.';
	}
	if (!copy('./files/egopay.tpl', '../skins/' . basename($_POST['skin_dir']) . '/admin/views/payments/components/cc_processors/egopay.tpl')) {
		$errors[] = 'Cannot copy egopay.tpl into your admin directory.';
	}

	$sql = "REPLACE INTO ?:language_values
			(lang_code, name, value)
			VALUES
			('EN', 'egopay_shop_id', 'Shop ID in EgoPay system'),
			('RU', 'egopay_shop_id', 'Shop ID в системе EgoPay'),
			('EN', 'egopay_login', 'Login in EgoPay system'),
			('RU', 'egopay_login', 'Логин в системе EgoPay'),
			('EN', 'egopay_password', 'Password in EgoPay system'),
			('RU', 'egopay_password', 'Пароль в системе EgoPay'),
			('EN', 'egopay_url', 'URL-address of EgoPay systame gateway'),
			('RU', 'egopay_url', 'Адрес шлюза EgoPay'),
			('EN', 'egopay_interface_language', 'EgoPay interface language'),
			('RU', 'egopay_interface_language', 'Язык интерфейса EgoPay'),
			('EN', 'egopay_russian', 'Russian'),
			('RU', 'egopay_russian', 'Русский'),
			('EN', 'egopay_english', 'English'),
			('RU', 'egopay_english', 'Английский'),
			('EN', 'egopay_german', 'German'),
			('RU', 'egopay_german', 'Немецкий'),
			('EN', 'egopay_chinese', 'Chinese'),
			('RU', 'egopay_chinese', 'Китайский'),
			('EN', 'egopay_register_ok', 'В скором времени будет осуществлён переход на сайт платёжной системы. Если по какой-либо причине это не произошло, Вы можете перейти <a href=\"[[url]]\">вручную</a>.'),
			('RU', 'egopay_register_ok', 'В скором времени будет осуществлён переход на сайт платёжной системы. Если по какой-либо причине это не произошло, Вы можете перейти <a href=\"[[url]]\">вручную</a>.'),
			('EN', 'egopay_error_during_pay', 'В процессе оплаты возникла ошибка: [[error_code]] [[error_string]]'),
			('RU', 'egopay_error_during_pay', 'В процессе оплаты возникла ошибка: [[error_code]] [[error_string]]'),
			('EN', 'egopay_try_again', 'Вы можете попробовать <a href=\"[[return_url]]\">оплатить снова</a>. В случае, если ошибка повторится, обратитесь к службе поддержки магазина.'),
			('RU', 'egopay_try_again', 'Вы можете попробовать <a href=\"[[return_url]]\">оплатить снова</a>. В случае, если ошибка повторится, обратитесь к службе поддержки магазина.'),
			('EN', 'egopay_order_status', 'Заказ принят в обработку (текущий статус: [[order_status]]), вы можете дождаться результата проверки платежа или <a href=\"[[return_url]]\">закончить оформление заказа</a>, не дожидаяcь изменения статуса.'),
			('RU', 'egopay_order_status', 'Заказ принят в обработку (текущий статус: [[order_status]]), вы можете дождаться результата проверки платежа или <a href=\"[[return_url]]\">закончить оформление заказа</a>, не дожидаяcь изменения статуса.'),
			('EN', 'egopay_status_unknown', 'unknown error'),
			('RU', 'egopay_status_unknown', 'неизвестная ошибка'),
			('EN', 'egopay_status_invalid', 'invalid order number'),
			('RU', 'egopay_status_invalid', 'заказ с таким номером не зарегистрирован'),
			('EN', 'egopay_status_acknowledged', 'успешная оплата, оформление успешно завершено'),
			('RU', 'egopay_status_acknowledged', 'успешная оплата, оформление успешно завершено'),
			('EN', 'egopay_status_not_authorized', 'оплата заказа не удалась'),
			('RU', 'egopay_status_not_authorized', 'оплата заказа не удалась'),
			('EN', 'egopay_status_registered', 'заказ зарегистрирован и ожидает оплаты'),
			('RU', 'egopay_status_registered', 'заказ зарегистрирован и ожидает оплаты'),
			('EN', 'egopay_status_in_progress', 'начата обработка платежа'),
			('RU', 'egopay_status_in_progress', 'начата обработка платежа'),
			('EN', 'egopay_status_authorized', 'успешная оплата, идёт оформление товара/услуги'),
			('RU', 'egopay_status_authorized', 'успешная оплата, идёт оформление товара/услуги'),
			('EN', 'egopay_status_failed', 'сбой в обработке заказа'),
			('RU', 'egopay_status_failed', 'сбой в обработке заказа'),
			('EN', 'egopay_status_not_acknowledged', 'успешная оплата. оформление не выполнено'),
			('RU', 'egopay_status_not_acknowledged', 'успешная оплата. оформление не выполнено')
			;";

	db_query($sql);

	$installed = true;
}

?>

<html>
<head>
	<title>CS-Cart EgoPay Install</title>
</head>
<body>
	<div style="text-align:center; margin-top: 15%">
		<h1>CS-Cart EgoPay Install</h1>
		<?php if ($installed): ?>
			<?php if (sizeof($errors) > 0):?>
				<h3>There was an errors during install:</h3>
				<ul>
					<?php foreach($errors as $e): ?>
						<li><?php echo $e ?></li>
					<?php endforeach ?>
				</ul>
			<?php else: ?>
				<h3>EgoPay payment module successfully installed. Now you can remove this directory.</h3>
			<?php endif ?>
		<?php else: ?>		
			<form action="index.php" method="post">
				<p>
					Select your skin:
					<select name="skin_dir">
						<?php $skinDir = dir('../skins/') ?>
	    					<?php while (false !== ($entry = $skinDir->read())): ?>
	    						<?php if (($entry != '.' && $entry != '..') && is_dir($skinDir->path . $entry)): ?>
	        						<option><?php echo $entry?></option>
	        					<?php endif ?>
	    					<?php endwhile ?>
    					<?php $skinDir->close() ?>
					</select>
				</p>
				<input type="submit" name="install" value="Install" />
			</form>
		<?php endif; ?>
	</div>
</body>
</html>