<?php

if (empty($argv[1]) || ($argv[1] !== '--cron')) {
	die();
}

define('AREA', 'C');
define('SKIP_SESSION_VALIDATION', true);

require(dirname(__FILE__) . '/../../prepare.php');
require(dirname(__FILE__) . '/../../init.php');

require_once(DIR_ROOT . '/payments/egopay_files/orderv2.php');
require_once(DIR_ROOT . '/payments/egopay_files/egopay.class.php');


// запрашиваем статусы заказов нашей платёжной системы

$processor = fn_get_processor_data_by_name('egopay.php');
// берём список активных платёжных систем и пытаемся найти egopay
foreach (fn_get_payment_by_processor($processor['processor_id']) as $pid => $p) {
	$paymentId = $pid;
	$processor_data = fn_get_processor_data($pid);
}

if (empty($processor_data)) {
	die('Не найден метод оплаты EgoPay');
}

// получаем заказы
$orders = fn_get_orders(array('payment_id' => $paymentId, 'status' => 'O'), 9999);

if (sizeof($orders[0]) > 0) {
	$soapClient = EgoPay::newSoap(array(
										'shop_id' => $processor_data['params']['shop_id'],
										'shop_url' => $processor_data['params']['url'],
										'shop_login' => $processor_data['params']['login'],
										'shop_pass' => $processor_data['params']['password'],
	));

	for ($i = 0, $l = sizeof($orders[0]); $i < $l; $i++) {
		$status = EgoPay::getOrderStatus($processor_data['params']['shop_id'], $orders[0][$i]['order_id']);
		$arFields = '';
		try {
			$info = $soapClient->get_status($status);
			if (!empty($info->error->category) && ($info->error->category != 'system') && ($info->error->code != 'ok')) {
				echo 'Ошибка для заказа № ', $orders[0][$i]['order_id'], ': ', $info->error->category, '>', $info->error->code, "\r\n";
			} else {
				if ($info->status === 'acknowledged') {
					// заказ успешно оплачен
					fn_change_order_status($orders[0][$i]['order_id'], 'P', $orders[0][$i]['status'], false);
				}
				if ($info->status === 'not_authorized') {
					// оплата заказа не удалась
					fn_change_order_status($orders[0][$i]['order_id'], 'F', $orders[0][$i]['status'], false);
				}
				echo 'Статус заказа № ', $orders[0][$i]['order_id'], ': ', $info->status, "\r\n";
			}
		} catch (SoapFault $fault) {
			echo 'Ошибка при проверке статуса заказа № ', $orders[0][$i]['order_id'], ': ', $fault->faultcode , '-' , $fault->faultstring, "\r\n";
			if ($fault->faultstring === 'INVALID_ORDER') {
				// заказ с таким номером не зарегистрирован
				fn_change_order_status($orders[0][$i]['order_id'], 'F', $orders[0][$i]['status'], false);
			}
		}
	}

}