<?php

if (!defined('AREA')) {
	die('Access denied');
}

require_once(DIR_ROOT . '/payments/egopay_files/orderv2.php');
require_once(DIR_ROOT . '/payments/egopay_files/egopay.class.php');


$view = Registry::get('view');
$prevTemplateDir = $view->template_dir;
$view->template_dir = DIR_ROOT . '/payments/egopay_files/templates/';


if (defined('PAYMENT_NOTIFICATION')) {
	$order_id = (int) $_REQUEST['order_id'];
	$order_info = fn_get_order_info($order_id);

	if (empty($processor_data)) {
		$processor_data = fn_get_processor_data($order_info['payment_id']);
	}
}


$returnUrl = Registry::get('config.current_location') . '/' . $index_script . '?dispatch=payment_notification.notify&payment=egopay&order_id=' . $order_id;
$settings = array(
					'shop_id' => $processor_data['params']['shop_id'],
					'shop_url' => $processor_data['params']['url'],
					'shop_login' => $processor_data['params']['login'],
					'shop_pass' => $processor_data['params']['password'],
					'language' => $processor_data['params']['language'],
					'order_id' => (int) $order_id,
					'order_sum' => $order_info['total'],
					'user_id' => (int) $_SESSION['auth']['user_id'],
					'user_name' => $order_info['b_lastname'] . ' ' . $order_info['b_firstname'],
					'user_email' => $order_info['email'],
					'user_phone' => $order_info['phone'],
					'return_url' => $returnUrl,
				);


if (defined('PAYMENT_NOTIFICATION')) {
	// возвратились от платёжной системы
	if (!empty($_REQUEST['status']) && ($_REQUEST['status'] == 'ok')) {
		$soapClient = EgoPay::newSoap($settings);
		$status = EgoPay::getOrderStatus($settings['shop_id'], $order_id);

		$pp_response = array();

		$final = false;

		try {
			$info = $soapClient->get_status($status);

			if (!empty($info->error->category) && ($info->error->category == 'system') && ($info->error->code == 'ok')) {
				$pp_response['reason_text'] = $info->status;
				$orderStatus = $info->status;

				if ($info->status === 'acknowledged') {
					// оплачиваем заказ
					$pp_response['order_status'] = 'P';
					$final = true;
				} elseif ($info->status === 'not_authorized') {
					// оплата заказа не удалась
					$pp_response['order_status'] = 'F';
					$final = true;
				} else {
					$pp_response['order_status'] = 'O';
				}
			} else {
				$pp_response['order_status'] = 'F';
			}
		} catch (SoapFault $fault) {
			$orderStatus = 'unknown';
			if ($fault->faultstring === 'INVALID_ORDER') {
				$orderStatus = 'invalid';
				$pp_response['order_status'] = 'F';
				$final = true;
			}
		}

	} else {
		$view->assign('error_code', 'Unknown error');
		$view->assign('error_string', '');
		$view->assign('return_url', Registry::get('config.current_location') . '/' . $index_script . '?dispatch=checkout.checkout');
		$template = $view->fetch('register_fault.tpl');
	}

	if (!empty($_GET['finish'])) {
		// пользователь закончил оформление заказа вручную
		$final = true;
	}

	if ($final) {
		// окончательный статус
		fn_finish_payment($order_id, $pp_response);
		fn_order_placement_routines($order_id, true, true, 'save');
	} else {
		// периодически обновляем страницу для получения нового статуса
		fn_finish_payment($order_id, $pp_response, false);

		if (empty($template)) {
			$view->assign('order_status', fn_get_lang_var('egopay_status_' . $orderStatus));
			$view->assign('return_url', $returnUrl . '&finish=true');
			$template = $view->fetch('order_status.tpl');
		}

		$view->template_dir = $prevTemplateDir;
		$view->assign('order_action', fn_get_lang_var('placing_order'));
		$view->display('views/orders/components/placing_order.tpl');

		die($template);
	}

} else {
	// пробуем зарегистрировать заказ
	$soapClient = EgoPay::newSoap($settings);
	$request = EgoPay::prepareOrder($settings);
	try {
		$info = $soapClient->register_online($request);
		// всё ок, зарегистрировали, перенаправляем на платёжную систему
		$view->assign('redirect_url', $info->redirect_url);
		$view->assign('session', $info->session);
		$view->display('register_ok.tpl');
	} catch (SoapFault $fault) {
		// ошибка, предлагаем попробовать снова
		$view->assign('error_code', $fault->faultcode);
		$view->assign('error_string', $fault->faultstring);
		$view->assign('return_url', Registry::get('config.current_location') . '/' . $index_script . '?dispatch=checkout.checkout');
		$view->display('register_fault.tpl');
	}

	die();
}