<?
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) {
    die();
}

set_time_limit(0);

//  
include(GetLangFileName(dirname(__FILE__) . '/', '/egopay.php'));
//  egopay
CModule::IncludeModule('egopay');

//       
$settings = array(
                    'shop_id' => CSalePaySystemAction::GetParamValue('SHOP_ID'),
                    'shop_login' => CSalePaySystemAction::GetParamValue('SHOP_LOGIN'),
                    'shop_pass' => CSalePaySystemAction::GetParamValue('SHOP_PASSWORD'),
                    'shop_url' => CSalePaySystemAction::GetParamValue('SHOP_URL'),
                    'order_id' => IntVal($GLOBALS['SALE_INPUT_PARAMS']['ORDER']['ID']),
);

$soapClient = CEgoPay::newSoap($settings);
$objStatus = CEgoPay::getOrderStatus($settings['shop_id'], $settings['order_id']);

//    
$arOrder = CSaleOrder::GetByID($settings['order_id']);

try {
    $info = $soapClient->get_status($objStatus);

    switch ($info->status) {
        case 'acknowledged':
        case 'not_acknowledged':
        case 'authorized':
            //   
            CEgoPay::updatePaymentStatus($order, 'Y', $info->status, $info->status);
            CSaleOrder::StatusOrder($settings['order_id'], CSalePaySystemAction::GetParamValue('PAY_STATUS'));
        break;

        default:
            CEgoPay::updatePaymentStatus($order, false, $info->status, $info->status);
        break;
    }

} catch (SoapFault $fault) {
    if ($fault->faultstring === 'INVALID_ORDER') {
        //      
        CEgoPay::updatePaymentStatus($order, 'N', GetMessage('EGOPAY_ORDER_INVALID'), $fault->faultstring);
        CSaleOrder::StatusOrder($settings['order_id'], 'N');
    }
}

return true;