<?
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) {
    die();
}

//  
include(GetLangFileName(dirname(__FILE__) . '/', '/egopay.php'));
//  egopay
CModule::IncludeModule('egopay');
//   
$templateDir = dirname(__FILE__) . '/templates/' . LANGUAGE_ID . '/';

//      
$SERVER_NAME_tmp = '';
if (defined('SITE_SERVER_NAME')) {
    $SERVER_NAME_tmp = (empty($_SERVER['HTTPS']) ? 'http://' : 'https://') . SITE_SERVER_NAME;
}
if (strlen($SERVER_NAME_tmp) <= 0) {
    $SERVER_NAME_tmp = (empty($_SERVER['HTTPS']) ? 'http://' : 'https://') . COption::GetOptionString('main', 'server_name', '');
}

try {
    $orderSum = CSalePaySystemAction::GetParamValue('SHOULD_PAY');
    if (false !== $i = strrpos($orderSum, ',')) {
        $orderSum[$i] = '.';
    }
    $orderSum = preg_replace('/[^0-9.]/', '', $orderSum);
    //       
    $settings = array(
        'shop_id' => CSalePaySystemAction::GetParamValue('SHOP_ID'),
        'shop_login' => CSalePaySystemAction::GetParamValue('SHOP_LOGIN'),
        'shop_pass' => CSalePaySystemAction::GetParamValue('SHOP_PASSWORD'),
        'shop_url' => CSalePaySystemAction::GetParamValue('SHOP_URL'),
        'order_id' => CSalePaySystemAction::GetParamValue('ORDER_ID'),
        'order_sum' => $orderSum,
        'user_id' => CSalePaySystemAction::GetParamValue('USER_ID'),
        'user_name' => mb_convert_encoding(CSalePaySystemAction::GetParamValue('USER_NAME'), 'UTF-8', LANG_CHARSET),
        'user_email' => CSalePaySystemAction::GetParamValue('USER_EMAIL'),
        'user_phone' => CSalePaySystemAction::GetParamValue('USER_PHONE'),
        'return_url' => $SERVER_NAME_tmp . '/personal/order/payment/?ORDER_ID=' . CSalePaySystemAction::GetParamValue('ORDER_ID'),
        'comment' => CSalePaySystemAction::GetParamValue('COMMENT'),
        'item_type' => CSalePaySystemAction::GetParamValue('ITEM_TYPE'),
        'item_desc' => CSalePaySystemAction::GetParamValue('ITEM_DESC'),
    );
} catch (Exception $e) {
    CEgoPay::fetch($templateDir . 'error.tpl', array('e' => $e->__toString()));
}


if (isset($_REQUEST['status'])) {
    //  

    if ($_REQUEST['status'] == 'ok') {
        //   ,  

        $soapClient = CEgoPay::newSoap($settings);
        $objStatus = CEgoPay::getOrderStatus($settings['shop_id'], $settings['order_id']);

        //    
        $order = Bitrix\Sale\Order::load($settings['order_id']);
        $arOrder = $order->getFieldValues();

        try {
            //      
            $info = $soapClient->get_status($objStatus);

            switch ($info->status) {
                case 'acknowledged':
                case 'not_acknowledged':
                case 'authorized':
                    CEgoPay::updatePaymentStatus($order, 'Y', $info->status, $info->status);
                    CSaleOrder::StatusOrder($settings['order_id'], CSalePaySystemAction::GetParamValue('PAY_STATUS'));

                    //     
                    $templateOrderStatus = GetMessage('EGOPAY_ORDER_SUCCESS');
                    $templateRedirectUrl = $SERVER_NAME_tmp . '/personal/order/detail/' . $settings['order_id'] . '/';
                break;

                case 'canceled':
                case 'not_authorized':
                    //    
                    CEgoPay::updatePaymentStatus($order, 'N', $info->status, $info->status);
                    CSaleOrder::StatusOrder($settings['order_id'], 'N');

                    $templateOrderStatus = GetMessage('EGOPAY_ORDER_FAIL');
                    $templateRedirectUrl = $SERVER_NAME_tmp . '/personal/order/detail/' . $settings['order_id'] . '/';
                break;

                case 'registered':
                    $templateOrderStatus = GetMessage('EGOPAY_ORDER_REGISTERED');
                    $templateRedirectUrl = $SERVER_NAME_tmp . '/personal/order/payment/?ORDER_ID=' . $settings['order_id'] . '&status=ok';
                break;

                case 'failed':
                case 'in_progress':
                    $templateOrderStatus = GetMessage('EGOPAY_ORDER_IN_PROGRESS');
                    $templateRedirectUrl = $SERVER_NAME_tmp . '/personal/order/payment/?ORDER_ID=' . $settings['order_id'] . '&status=ok';
                break;

                default:
                    $templateOrderStatus = GetMessage('EGOPAY_ORDER_PROCESSING');
                    $templateRedirectUrl = $SERVER_NAME_tmp . '/personal/order/detail/' . $settings['order_id'] . '/';

                break;
            }

        } catch (SoapFault $fault) {
            if ($fault->faultstring === 'INVALID_ORDER') {
                //      
                CEgoPay::updatePaymentStatus($order, 'N', GetMessage('EGOPAY_ORDER_INVALID'), $fault->faultstring);
                CSaleOrder::StatusOrder($settings['order_id'], 'N');

                $templateOrderStatus = GetMessage('EGOPAY_ORDER_FAIL');
                $templateRedirectUrl = $SERVER_NAME_tmp . '/personal/order/payment/?ORDER_ID=' . $settings['order_id'];
            }
        } catch (Exception $e) {
            CEgoPay::fetch($templateDir . 'pay_fault.tpl', array('form_url' => $SERVER_NAME_tmp . '/personal/order/payment/?ORDER_ID=' . $settings['order_id'], 'e' => $e->__toString()));
        }

        //       
        CEgoPay::fetch($templateDir . 'order_status.tpl', array(
                                                                'order_status' => $templateOrderStatus,
                                                                'redirect_url' => $templateRedirectUrl,
                                                                'detail_url' => $SERVER_NAME_tmp . '/personal/order/detail/' . intval($_REQUEST['ORDER_ID']) . '/'));
    }

    if ($_REQUEST['status'] == 'fault') {
        //    
        CEgoPay::fetch($templateDir . 'pay_cancel.tpl', array('form_url' => $SERVER_NAME_tmp . '/personal/order/payment/?ORDER_ID=' . intval($_REQUEST['ORDER_ID']), 'e' => ''));
    }

} else {

    $arOrder = CSaleOrder::GetByID($settings['order_id']);
    if (($arOrder['CANCELED'] == 'N') && ($arOrder['PS_STATUS'] != 'Y')) {

        if (!empty($_POST['ready_to_pay'])) {
            $soapClient = CEgoPay::newSoap($settings);
            $request = CEgoPay::prepareOrder($settings);
            try {
                CSaleOrder::StatusOrder($settings['order_id'], 'E');
                CSaleOrder::Update($settings['order_id'], array('PS_STATUS' => ''));

                $info = $soapClient->register_online($request);
                //  , ,    
                CEgoPay::fetch($templateDir . 'register_ok.tpl', array(
                                                                        'redirect_url' => $info->redirect_url,
                                                                        'session' => $info->session));
            } catch (SoapFault $fault) {
                // ,   
                CEgoPay::fetch($templateDir . 'register_fault.tpl', array(
                                                                            'error_code' => $fault->faultcode,
                                                                            'error_string' => $fault->faultstring,
                                                                            'form_url' => $SERVER_NAME_tmp . '/personal/order/payment/?ORDER_ID=' . intval($_REQUEST['ORDER_ID'])));
            } catch (Exception $e) {
                CEgoPay::fetch($templateDir . 'pay_fault.tpl', array('form_url' => $SERVER_NAME_tmp . '/personal/order/payment/?ORDER_ID=' . $settings['order_id'], 'e' => $e->__toString()));
            }
        } else {
            //   
            CEgoPay::fetch($templateDir . 'prepare.tpl', array(
                                                                'sum' => $settings['order_sum'],
                                                                'action' => $settings['return_url']
                                                              ), false);
        }
    }

}
