<?
require_once($_SERVER['DOCUMENT_ROOT'] . '/bitrix/modules/egopay/classes/general/orderv2.php');

class CEgoPay {

    // -
    public static function fetch($templateName, $variables, $includeTemplate = true) {
        $result = file_get_contents($templateName);
        $_v = array();
        foreach ($variables as $key => $value) {
            $_v['{{' . $key . '}}'] = $value;
        }
        $result = strtr($result, $_v);

        $templatePath = 'bitrix';
        if (defined('SITE_TEMPLATE_PATH')) {
            $templatePath = SITE_TEMPLATE_PATH;
        }

        if ($includeTemplate) {
            global $APPLICATION; 
            require($_SERVER['DOCUMENT_ROOT'] . '/' . $templatePath . '/header.php');
            echo $result;
            require($_SERVER['DOCUMENT_ROOT'] . '/' . $templatePath . '/footer.php');
        } else {
            echo $result;
        }
    }

    public static function updatePaymentStatus(&$order, $payed, $message, $description) {
        $arOrder = $order->getFieldValues();
        $payment = $order->getPaymentCollection();
        $payment = $payment[0];
        $fields = array(
            'PS_STATUS_CODE' => '-',
            'PS_STATUS_DESCRIPTION' => $description,
            'PS_STATUS_MESSAGE' => $message,
            'PS_RESPONSE_DATE' => new \Bitrix\Main\Type\DateTime(),
        );
        if ($payed !== false) {
            $payment->setField('PAID', $payed);
            $fields['PS_SUM'] = $arOrder['PRICE'];
            $fields['PS_CURRENCY'] = $arOrder['CURRENCY'];
            $fields['PS_STATUS'] = $payed;
        }
        $payment->setFields($fields);
        $order->save();
    }

    //   soap-
    public static function newSoap($settings) {
        return new orderv2(
            null,
            array(
                'location' => $settings['shop_url'],
                'uri' => 'http://www.sirena-travel.ru',
                'login' => $settings['shop_login'],
                'password' => $settings['shop_pass'],
                'trace' => 0,
                'features' => SOAP_SINGLE_ELEMENT_ARRAYS,
                'connection_timeout' => 12
            )
        );
    }

    //     
    public static function prepareOrder($settings) {
        $request = new register_online();
        $order = new OrderID(); 
        $order->shop_id = $settings['shop_id'];
        $order->number = $settings['order_id'];
        $cost = new Amount();
        $cost->amount = $settings['order_sum'];
        $cost->currency = 'RUB';
        $customer = new CustomerInfo();
        if ($settings['user_id'] != 0) {
            $customer->id = $settings['user_id'];
        }
        $customer->name = $settings['user_name'];
        if (!empty($settings['user_email']) && $settings['user_email']) {
            $customer->email = $settings['user_email'];
        }
        if (!empty($settings['user_phone']) && $settings['user_phone']) {
            $customer->phone = $settings['user_phone'];
        }

        $description = new OrderInfo();
        $description->paytype = 'card';
        if (!empty($settings['item_type'])) {
            $itemCost = new Amount();
            $itemCost->amount = $settings['order_sum'];
            $itemCost->currency = 'RUB';

            $item = new OrderItem();
            $item->typename = $settings['item_type'];
            $item->number = $settings['order_id'];
            $item->amount = $itemCost;
            $item->descr = $settings['item_desc'];

            $description->items = new SoapVar(
                array(
                    new SoapVar($item, SOAP_ENC_OBJECT, null, null, 'OrderItem'),
                ),
                SOAP_ENC_OBJECT
            );
        }

        $language = new PostEntry();
        $language->name = 'Language';
        $language->value = 'ru';
        $returnUrlOk = new PostEntry();
        $returnUrlOk->name = 'ReturnURLOk';
        $returnUrlOk->value = $settings['return_url'] . '&status=ok';
        $returnUrlFault = new PostEntry();
        $returnUrlFault->name = 'ReturnURLFault';
        $returnUrlFault->value = $settings['return_url'] . '&status=fault';
        $cardtype = new PostEntry();
        $cardtype->name = 'ChoosenCardType';
        $cardtype->value = 'VI';
        $request->order = $order;
        $request->cost = $cost;
        $request->customer = $customer;
        $request->description = $description;

        $postdata = array(
            new SoapVar($language, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
            new SoapVar($cardtype, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
            new SoapVar($returnUrlOk, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
            new SoapVar($returnUrlFault, SOAP_ENC_OBJECT, null, null, 'PostEntry')
        );
        if (!empty($settings['comment'])) {
            $comment = new PostEntry();
            $comment->name = 'Comment';
            $comment->value = $settings['comment'];
            $postdata[] = new SoapVar($comment, SOAP_ENC_OBJECT, null, null, 'PostEntry');
        }

        $request->postdata = new SoapVar($postdata, SOAP_ENC_OBJECT);

        return $request;
    }

    //      
    public static function getOrderStatus($shopId, $orderId) {
        $status = new get_status();
        $order = new OrderID();
        $order->shop_id = $shopId;
        $order->number = $orderId;
        $status->order = $order;
        return $status;
    }

    //      
    public static function checkOrders() {
        CModule::IncludeModule('sale');
        //     
        $paymentSystemList = CSalePaySystemAction::GetList(array(), array('PS_ACTIVE' => 'Y', '%ACTION_FILE' => 'egopay'));

        //   egopay
        $paymentSystemId = 0;
        while ($ps = $paymentSystemList->Fetch()) {
            $paymentSystemId = $ps['PAY_SYSTEM_ID'];
        }
        if (!$paymentSystemId) {
            die('     EgoPay');
        }

        //  
        $orders = array();
        $ordersList = CSaleOrder::GetList(array(), array('PAY_SYSTEM_ID' => $paymentSystemId, 'PAYED' => 'N', 'CANCELED' => 'N', 'STATUS_ID' => 'E', 'PS_STATUS' => ''));
        while ($o = $ordersList->Fetch()) {
            $orders[] = $o;
        }

        if (sizeof($orders) > 0) {
            CSalePaySystemAction::InitParamArrays($orders[0], $orders[0]['ID']);

            $soapClient = self::newSoap(array(
                'shop_id' => CSalePaySystemAction::GetParamValue('SHOP_ID'),
                'shop_login' => CSalePaySystemAction::GetParamValue('SHOP_LOGIN'),
                'shop_pass' => CSalePaySystemAction::GetParamValue('SHOP_PASSWORD'),
                'shop_url' => CSalePaySystemAction::GetParamValue('SHOP_URL'),
            ));

            for ($i = 0, $l = sizeof($orders); $i < $l; $i++) {
                $objStatus = self::getOrderStatus(CSalePaySystemAction::GetParamValue('SHOP_ID'), $orders[$i]['ID']);
                $order = Bitrix\Sale\Order::load($orders[$i]['ID']);

                try {
                    $info = $soapClient->get_status($objStatus);

                    switch ($info->status) {
                        case 'acknowledged':
                        case 'not_acknowledged':
                        case 'authorized':
                            //   
                            CEgoPay::updatePaymentStatus(
                                $order,
                                'Y',
                                $info->status,
                                $info->status
                            );
                            CSaleOrder::StatusOrder($orders[$i]['ID'], CSalePaySystemAction::GetParamValue('PAY_STATUS'));
                        break;

                        case 'canceled':
                        case 'not_authorized':
                            //    
                            CEgoPay::updatePaymentStatus(
                                $order,
                                'N',
                                $info->status,
                                $info->status
                            );
                            CSaleOrder::StatusOrder($orders[$i]['ID'], 'N');
                        break;

                        default:
                            CEgoPay::updatePaymentStatus(
                                $order,
                                false,
                                $info->status,
                                $info->status
                            );
                        break;
                    }
                    echo '   ', $orders[$i]['ID'], ': ', $info->status, "\r\n";

                } catch (SoapFault $fault) {
                    echo '     ' , $fault->faultcode , '-' , $fault->faultstring, "\r\n";
                    if ($fault->faultstring === 'INVALID_ORDER') {
                        //      
                        CEgoPay::updatePaymentStatus(
                            $order,
                            'N',
                            '     ',
                            $fault->faultstring
                        );
                        CSaleOrder::StatusOrder($orders[$i]['ID'], 'N');
                    }
                }
            }

        }

        return 'CEgoPay::CheckOrders();';
    }

}
