<?php
    if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) {
        die();
    }
    $GLOBALS['APPLICATION']->SetAdditionalCSS('/bitrix/components/ips/standalone/css/ips.css');
?>
<div class="ips-order__block">
    <?php if (!empty($arResult['error']) && $arResult['error'] !== false) { ?>
        <p class="ips-order__block__error">
            <?php
                switch($arResult['error']) {
                    case 'module':
                        echo 'Не установлен модуль оплаты IPS.';
                    break;

                    case 'settings':
                        echo 'Не заданы необходимые настройки.';
                    break;

                    case 'ips_order':
                        echo 'Введите номер заказа.';
                    break;

                    case 'ips_sum':
                        echo 'Сумма должна быть больше 0.';
                    break;

                    case 'fault':
                        echo 'При регистрации заказа в платёжной системе произошла ошибка. Пожалуйста, свяжитесь со службой поддержки магазина и сообщите им код ошибки, приведённый ниже.';
                    break;

                    default:
                        echo 'Произошла ошибка. Пожалуйста, попробуйте оплатить снова. В случае, если ошибка повторится, обратитесь к службе поддержки магазина.';
                }
            ?>
        </p>
        <?php if (!empty($arResult['error_code'])) { ?>
            <p class="ips-order__block__error ips-order__block__error-code"><?php echo $arResult['error_code'] ?></p>
        <?php } ?>
    <?php } ?>

    <?php if (!empty($arResult['redirect_url'])) { ?>
        <p class="ips-order__block__message">В скором времени будет осуществлён переход на сайт платёжной системы. Если по какой-либо причине это не произошло, Вы можете перейти <a href="<?php echo $arResult['redirect_url'] ?>?session=<?php echo $arResult['redirect_session'] ?>" class="ips-order__block__message__link">самостоятельно</a>.</p>
        <script type="text/javascript">
            window.location = "<?php echo $arResult['redirect_url'] ?>?session=<?php echo $arResult['redirect_session'] ?>";
        </script>
    <?php } else { ?>

        <form action="" method="POST">
            <p class="ips-order__block__label ips-order__block__label-order">
                Номер заказа
            </p>
            <p class="ips-order__block__input-row ips-order__block__input-row-order">
                <input type="text" name="ips_order" value="<?php echo empty($_POST['ips_order']) ? '' : htmlspecialchars($_POST['ips_order']) ?>" class="ips-order__block__input ips-order__block__input-order" />
            </p>
            <p class="ips-order__block__label ips-order__block__label-sum">
                Сумма
            </p>
            <p class="ips-order__block__input-row ips-order__block__input-row-sum">
                <input type="text" name="ips_sum" value="<?php echo empty($_POST['ips_sum']) ? '' : htmlspecialchars($_POST['ips_sum']) ?>" class="ips-order__block__input ips-order__block__input-sum" />
            </p>
            <p class="ips-order__block__input-row ips-order__block__input-row-submit">
                <input type="submit" value="Оплатить" class="ips-order__block__input ips-order__block__input-submit" />
            </p>
        </form>
    <?php } ?>
</div>
