<?php
    if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) {
        die();
    }

    if (!CModule::IncludeModule('ips')) {
        $arResult['error'] = 'module';
        $this->IncludeComponentTemplate();
        return;
    }

    function commonErrors($arParams) {
        if (empty($arParams['SHOP_ID']) || empty($arParams['LOGIN']) || empty($arParams['PASSWORD']) || empty($arParams['SERVICE_URL'])) {
            return 'settings';
        }

        if (empty($_POST['ips_order'])) {
            return 'ips_order';
        }
        if (empty($_POST['ips_sum']) || $_POST['ips_sum'] <= 0) {
            return 'ips_sum';
        }

        return false;
    }
    
    if (isset($_POST['ips_order'])) {
        if (($arResult['error'] = commonErrors($arParams)) === false) {
            try {
                $orderSum = str_replace(',', '.', $_POST['ips_sum']);
                $orderSum = preg_replace('/\.(?=.*\.)/', '', $_POST['ips_sum']);
                $orderSum = preg_replace('/[^0-9.]/', '', $orderSum);

                if (empty($arParams['RETURN_URL_OK'])) {
                    if (defined('SITE_SERVER_NAME')) {
                        $returnUrlOk = (empty($_SERVER['HTTPS']) ? 'http://' : 'https://') . SITE_SERVER_NAME;
                    }
                    if (strlen($returnUrlOk) <= 0) {
                        $returnUrlOk = (empty($_SERVER['HTTPS']) ? 'http://' : 'https://') . COption::GetOptionString('main', 'server_name', '');
                    }
                } else {
                    $returnUrlOk = $arParams['RETURN_URL_OK'];
                }

                if (empty($arParams['RETURN_URL_FAIL'])) {
                    if (defined('SITE_SERVER_NAME')) {
                        $returnUrlFail = (empty($_SERVER['HTTPS']) ? 'http://' : 'https://') . SITE_SERVER_NAME;
                    }
                    if (strlen($returnUrlFail) <= 0) {
                        $returnUrlFail = (empty($_SERVER['HTTPS']) ? 'http://' : 'https://') . COption::GetOptionString('main', 'server_name', '');
                    }
                } else {
                    $returnUrlFail = $arParams['RETURN_URL_FAIL'];
                }

                $soapClient = CIPS::newSoap($arParams['SERVICE_URL'], $arParams['LOGIN'], $arParams['PASSWORD']);
                $request = CIPS::prepareOrder($arParams['SHOP_ID'], $_POST['ips_order'], $orderSum, $returnUrlOk, $returnUrlFail);

                $info = $soapClient->register_online($request);
                $arResult['redirect_url'] = $info->redirect_url;
                $arResult['redirect_session'] = $info->session;
            } catch (SoapFault $fault) {
                $arResult['error'] = 'fault';
                $arResult['error_code'] = $fault->faultstring;
            } catch (Exception $e) {
                $arResult['error'] = 'fault';
                $arResult['error_code'] = $e->__toString();
            }
        }
    }

    $this->IncludeComponentTemplate();
?>
