<?
require_once($_SERVER['DOCUMENT_ROOT'] . '/bitrix/modules/ips/classes/general/orderv2.php');

class CIPS {


    public static function newSoap($url, $login, $password) {
        return new orderv2(
            null,
            array(
                'location' => $url,
                'uri' => 'http://www.sirena-travel.ru',
                'login' => $login,
                'password' => $password,
                'trace' => 0,
                'features' => SOAP_SINGLE_ELEMENT_ARRAYS,
                'connection_timeout' => 12
            )
        );
    }


    public static function prepareOrder($shopId, $orderId, $orderSum, $returnUrlOkey, $returnUrlFail) {
        $request = new register_online();
        $order = new OrderID(); 
        $order->shop_id = $shopId;
        $order->number = $orderId;
        $cost = new Amount();
        $cost->amount = $orderSum;
        $cost->currency = 'RUB';

        $description = new OrderInfo();
        $description->paytype = 'card';

        $language = new PostEntry();
        $language->name = 'Language';
        $language->value = 'ru';
        $returnUrlOk = new PostEntry();
        $returnUrlOk->name = 'ReturnURLOk';
        $returnUrlOk->value = $returnUrlOkey;
        $returnUrlFault = new PostEntry();
        $returnUrlFault->name = 'ReturnURLFault';
        $returnUrlFault->value = $returnUrlFail;
        $cardtype = new PostEntry();
        $cardtype->name = 'ChoosenCardType';
        $cardtype->value = 'VI';
        $request->order = $order;
        $request->cost = $cost;
        $request->description = $description;

        $postdata = array(
            new SoapVar($language, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
            new SoapVar($cardtype, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
            new SoapVar($returnUrlOk, SOAP_ENC_OBJECT, null, null, 'PostEntry'),
            new SoapVar($returnUrlFault, SOAP_ENC_OBJECT, null, null, 'PostEntry')
        );

        $request->postdata = new SoapVar($postdata, SOAP_ENC_OBJECT);

        return $request;
    }

}
